/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.GMFDiagramUpdater;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class PrepareDiagramCommand
extends RecordingCommand {
    private static final NullProgressMonitor MONITOR = new NullProgressMonitor();
    private static final String SUFFIXE_COPY = "_copy";
    private List<Layer> layers;
    private DRepresentation representation;
    private DDiagram exportedDiagram;
    private Session session;
    private TransactionalEditingDomain editingDomain;
    private boolean isRepresentationOpened;
    private boolean refreshRepresentations;

    public PrepareDiagramCommand(TransactionalEditingDomain domain, List<Layer> layers, DDiagram diagram, Session session, boolean isDiagramOpened, boolean refreshRepresentations) {
        super(domain);
        this.editingDomain = domain;
        this.layers = layers;
        this.representation = diagram;
        this.session = session;
        this.isRepresentationOpened = isDiagramOpened;
        this.refreshRepresentations = refreshRepresentations;
    }

    protected void doExecute() {
        if (this.layers.isEmpty() && this.representation instanceof DDiagram) {
            this.exportedDiagram = (DDiagram)this.representation;
            if (!this.isRepresentationOpened && this.refreshRepresentations) {
                DialectManager.INSTANCE.refresh((DRepresentation)this.exportedDiagram, (IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            this.exportedDiagram = (DDiagram)DialectManager.INSTANCE.copyRepresentation(this.representation, this.representation.getName() + SUFFIXE_COPY, this.session, (IProgressMonitor)MONITOR);
            Command compoundCmd = this.activateLayers(this.exportedDiagram);
            if (!this.isRepresentationOpened) {
                new GMFDiagramUpdater(this.session, (DDiagram)this.representation);
            }
            this.session.getTransactionalEditingDomain().getCommandStack().execute(compoundCmd);
        }
    }

    protected Command activateLayers(DDiagram diagram) {
        ChangeLayerActivationCommand cmd;
        CompoundCommand compoundCmd = new CompoundCommand();
        for (Layer layer : new ArrayList(diagram.getActivatedLayers())) {
            cmd = new ChangeLayerActivationCommand(this.editingDomain, diagram, layer, (IProgressMonitor)MONITOR);
            compoundCmd.append((Command)cmd);
        }
        for (Layer layer : this.layers) {
            cmd = new ChangeLayerActivationCommand(this.editingDomain, diagram, layer, (IProgressMonitor)MONITOR);
            compoundCmd.append((Command)cmd);
        }
        return compoundCmd;
    }

    public DDiagram getExportedDiagram() {
        return this.exportedDiagram;
    }
}

