/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.obeonetwork.m2doc.ide.DeclaredTemplatesListener;
import org.obeonetwork.m2doc.ide.DeclaredTokensListener;
import org.obeonetwork.m2doc.ide.services.configurator.ServicesConfiguratorRegistryListener;
import org.obeonetwork.m2doc.ide.util.ClassProviderRegistryListener;
import org.obeonetwork.m2doc.ide.util.EclipseClassProvider;
import org.obeonetwork.m2doc.ide.util.IClassProviderDescriptor;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.osgi.framework.BundleContext;

public class M2DocPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc.ide";
    public static final M2DocPlugin INSTANCE = new M2DocPlugin();
    private static Implementation plugin;
    private static IClassProvider classProvider;
    private static BundleContext bundlerContext;
    private static final List<IClassProviderDescriptor> PROVIDERS;

    static {
        classProvider = new ClassProvider(M2DocPlugin.class.getClassLoader());
        PROVIDERS = new ArrayList<IClassProviderDescriptor>();
    }

    public M2DocPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static IClassProvider getClassProvider() {
        if (classProvider.getClass() == ClassProvider.class) {
            classProvider = !PROVIDERS.isEmpty() ? PROVIDERS.get(0).getClassProvider() : new EclipseClassProvider(bundlerContext, ((Object)((Object)M2DocPlugin.getPlugin())).getClass().getClassLoader());
        }
        return classProvider;
    }

    public static void setClassProvider(EclipseClassProvider classProvider) {
        M2DocPlugin.classProvider = classProvider;
    }

    public static M2DocPlugin getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassProvider(IClassProviderDescriptor configurator) {
        if (configurator != null) {
            List<IClassProviderDescriptor> list = PROVIDERS;
            synchronized (list) {
                PROVIDERS.add(configurator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClassProvider(IClassProviderDescriptor providerDescriptor) {
        if (providerDescriptor != null) {
            List<IClassProviderDescriptor> list = PROVIDERS;
            synchronized (list) {
                PROVIDERS.remove(providerDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IClassProvider> getProviders() {
        ArrayList<IClassProvider> res = new ArrayList<IClassProvider>();
        List<IClassProviderDescriptor> list = PROVIDERS;
        synchronized (list) {
            for (IClassProviderDescriptor descriptor : PROVIDERS) {
                EclipseClassProvider configurator = descriptor.getClassProvider();
                if (configurator == null) continue;
                res.add((IClassProvider)configurator);
            }
        }
        return res;
    }

    public static BundleContext getBundlerContext() {
        return bundlerContext;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private ServicesConfiguratorRegistryListener registryListener = new ServicesConfiguratorRegistryListener();
        private ClassProviderRegistryListener providerListener = new ClassProviderRegistryListener();
        private DeclaredTokensListener servicesListener = new DeclaredTokensListener();
        private DeclaredTemplatesListener templatesListener = new DeclaredTemplatesListener();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.registryListener, "org.obeonetwork.m2doc.ide.servicesConfigurator");
            this.registryListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.providerListener, "org.obeonetwork.m2doc.ide.classprovider");
            this.providerListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.servicesListener, "org.obeonetwork.m2doc.ide.services.register");
            this.servicesListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.templatesListener, "org.obeonetwork.m2doc.ide.templates.register");
            this.templatesListener.parseInitialContributions();
            bundlerContext = context;
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            if (classProvider instanceof EclipseClassProvider) {
                ((EclipseClassProvider)classProvider).dispose();
            }
            classProvider = new ClassProvider(M2DocPlugin.class.getClassLoader());
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.registryListener);
            registry.removeListener((IRegistryEventListener)this.servicesListener);
        }
    }
}

