/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.util;

import java.util.HashMap;
import java.util.Map;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class EclipseClassProvider
extends ClassProvider {
    private final BundleContext context;
    private final Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private final BundleListener listener;

    public EclipseClassProvider(BundleContext context, ClassLoader classLoader) {
        super(classLoader);
        this.context = context;
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            this.bundles.put(bundle.getSymbolicName(), bundle);
            ++n2;
        }
        this.listener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 1: {
                        EclipseClassProvider.this.bundles.put(event.getBundle().getSymbolicName(), event.getBundle());
                        break;
                    }
                    case 16: {
                        EclipseClassProvider.this.bundles.remove(event.getBundle().getSymbolicName());
                        break;
                    }
                }
            }
        };
        context.addBundleListener(this.listener);
    }

    public Class<?> getClass(String className, String bundleName) throws ClassNotFoundException {
        Bundle bundle = this.bundles.get(bundleName);
        Class res = bundle != null ? bundle.loadClass(className) : super.getClass(className, bundleName);
        return res;
    }

    public void dispose() {
        this.context.removeBundleListener(this.listener);
    }
}

