/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.ide.ui.util.ClassPropertyUpdaterRegistryListener;
import org.obeonetwork.m2doc.ide.ui.util.IClassPropertyUpdater;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.osgi.framework.BundleContext;

public class M2DocUIPlugin
extends AbstractUIPlugin {
    public static final String DELETE_IMG_KEY = "delete";
    public static final String ADD_IMG_KEY = "add";
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc.ide.ui";
    public static final String LIBRARIES_PREFERENCES = "librariesPrefrences";
    private static M2DocUIPlugin plugin;
    private static final ClassPropertyUpdaterRegistryListener CLASS_PROPERTY_UPDATER_REGISTERY_LISTENER;
    private static IClassPropertyUpdater classPropertyUpdater;

    static {
        CLASS_PROPERTY_UPDATER_REGISTERY_LISTENER = new ClassPropertyUpdaterRegistryListener();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)CLASS_PROPERTY_UPDATER_REGISTERY_LISTENER, "org.obeonetwork.m2doc.ide.servicesConfigurator");
        CLASS_PROPERTY_UPDATER_REGISTERY_LISTENER.parseInitialContributions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)CLASS_PROPERTY_UPDATER_REGISTERY_LISTENER);
    }

    public static M2DocUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return M2DocUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        try {
            reg.put(ADD_IMG_KEY, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.obeonetwork.m2doc.ide.ui/icons/add.gif")));
            reg.put(DELETE_IMG_KEY, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.obeonetwork.m2doc.ide.ui/icons/delete.gif")));
        }
        catch (MalformedURLException e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    public static IClassPropertyUpdater getClassPropertyUpdater() {
        return classPropertyUpdater;
    }

    public static void registerClassPropertyUpdater(IClassPropertyUpdater updater) {
        classPropertyUpdater = updater;
    }

    public Map<File, TemplateCustomProperties> getCompatibleTemplatesFromLibraries(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> types) {
        LinkedHashMap<File, TemplateCustomProperties> res = new LinkedHashMap<File, TemplateCustomProperties>();
        List<File> templateFiles = this.getAllTemplatesFromLibraries();
        for (File templateFile : templateFiles) {
            try {
                TemplateCustomProperties properties = POIServices.getInstance().getTemplateCustomProperties(URIConverter.INSTANCE, URI.createFileURI((String)templateFile.getAbsolutePath()));
                AstValidator validator = new AstValidator(new ValidationServices(queryEnvironment));
                Map variableTypes = properties.getVariableTypes(validator, queryEnvironment);
                if (variableTypes.size() != 1 || !this.isCompatible(types, (Set)variableTypes.entrySet().iterator().next().getValue())) continue;
                res.put(templateFile, properties);
            }
            catch (Exception e) {
                M2DocUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "can't load from library: " + templateFile.getAbsolutePath(), (Throwable)e));
            }
        }
        return res;
    }

    public List<File> getAllTemplatesFromLibraries() {
        ArrayList<File> res = new ArrayList<File>();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String librariesString = preferenceStore.getString(LIBRARIES_PREFERENCES);
        if (librariesString != null) {
            String[] stringArray = librariesString.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String libraryString = stringArray[n2];
                File library = new File(libraryString);
                res.addAll(this.getAllTemplates(library));
                ++n2;
            }
        }
        return res;
    }

    private boolean isCompatible(Set<IType> variableTypes, Set<IType> declarationTypes) {
        boolean res = false;
        block0: for (IType variableType : variableTypes) {
            for (IType declarationType : declarationTypes) {
                if (!declarationType.isAssignableFrom(variableType)) continue;
                res = true;
                break block0;
            }
        }
        return res;
    }

    private List<File> getAllTemplates(File library) {
        ArrayList<File> res = new ArrayList<File>();
        if (library.exists() && library.isDirectory()) {
            FileFilter folderFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            };
            FilenameFilter templateFiles = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowerCaseName = name.toLowerCase();
                    return lowerCaseName.endsWith(".docx");
                }
            };
            File[] fileArray = library.listFiles(templateFiles);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                res.add(file);
                ++n2;
            }
            fileArray = library.listFiles(folderFilter);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                File subFolder = fileArray[n2];
                res.addAll(this.getAllTemplates(subFolder));
                ++n2;
            }
        }
        return res;
    }
}

