/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.command;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class MigrateTemplateHandler
extends AbstractHandler {
    private static final String DOT = ".";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                IFile templateFile = (IFile)selected;
                MigrationJob job = new MigrationJob(templateFile);
                job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                job.schedule();
            }
        }
        return null;
    }

    private final class MigrationJob
    extends Job {
        private final URI templateURI;
        private final IFile templateFile;

        private MigrationJob(IFile templateFile) {
            super("Migrate " + templateFile.getFullPath().toString());
            this.templateURI = URI.createPlatformResourceURI((String)templateFile.getFullPath().toString(), (boolean)true);
            this.templateFile = templateFile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status status;
            try {
                URI targetURI = URI.createURI((String)this.templateFile.getName().replace(".docx", "-migrated.docx")).resolve(this.templateURI);
                URI targetErrorURI = URI.createURI((String)this.templateFile.getName().replace(".docx", "-migrated-errors.docx")).resolve(this.templateURI);
                List messages = M2DocUtils.migrate((URIConverter)URIConverter.INSTANCE, (URI)this.templateURI, (URI)targetURI, (URI)targetErrorURI, (Monitor)BasicMonitor.toMonitor((IProgressMonitor)monitor));
                status = !messages.isEmpty() ? new Status(4, ((Object)((Object)this)).getClass(), "Errors while migrating " + String.valueOf(this.templateURI) + " see " + String.valueOf(targetErrorURI) + MigrateTemplateHandler.DOT) : new Status(0, ((Object)((Object)this)).getClass(), String.valueOf(this.templateURI) + " migrated.");
                this.templateFile.getParent().refreshLocal(1, monitor);
            }
            catch (CoreException | DocumentParserException e) {
                status = new Status(4, ((Object)((Object)this)).getClass(), "Can't migrate " + String.valueOf(this.templateURI), e);
            }
            return status;
        }
    }
}

