/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.element.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;

public class MImageSWTImpl
implements MImage {
    private final ImageData image;
    private final URI uri;
    private int width;
    private int height;
    private int relativeWidth = -1;
    private int relativeHeight = -1;
    private boolean conserveRatio;
    private double ratio;

    public MImageSWTImpl(ImageData image) {
        this.image = image;
        this.uri = URI.createURI((String)("SWT." + this.getType().name().toLowerCase()));
        this.width = image.width;
        this.height = image.height;
        this.conserveRatio = true;
        this.ratio = (double)this.width / (double)this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.conserveRatio) {
            this.height = (int)(1.0 / this.getRatio() * (double)width);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.conserveRatio) {
            this.width = (int)(this.getRatio() * (double)height);
        }
    }

    public int getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(int relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    public int getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(int relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    public boolean conserveRatio() {
        return this.conserveRatio;
    }

    public void setConserveRatio(boolean conserveRatio) {
        if (conserveRatio && this.ratio < 0.0) {
            throw new IllegalStateException("Can't conserve ratio: unknown ratio");
        }
        this.conserveRatio = conserveRatio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getInputStream() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{this.image};
            imageLoader.save((OutputStream)output, 5);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public PictureType getType() {
        return PictureType.PNG;
    }

    public String toString() {
        return "Image " + this.uri.toString();
    }

    public static ImageData getImage(MImage image) throws IOException {
        ImageData res;
        ImageLoader imageLoader = new ImageLoader();
        if (image instanceof MImageSWTImpl) {
            res = ((MImageSWTImpl)image).image;
        } else {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream input = image.getInputStream();){
                res = imageLoader.load(input)[0];
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return res;
    }
}

