/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class M2DocNewTemplatePage
extends WizardPage {
    private final WizardNewProjectCreationPage newProjectPage;
    private Text templateNameText;
    private String templateName;
    private final String defaultTempateName;

    public M2DocNewTemplatePage(WizardNewProjectCreationPage newProjectPage) {
        super("Select M2Doc template name.");
        this.newProjectPage = newProjectPage;
        this.defaultTempateName = null;
    }

    public M2DocNewTemplatePage(String defaultTempateName) {
        super("Select M2Doc template name.");
        this.newProjectPage = null;
        this.defaultTempateName = defaultTempateName;
    }

    private void setTemplateName(String templateName) {
        this.templateName = templateName;
        this.validatePage(templateName);
    }

    public void createControl(Composite parent) {
        Composite templateNameComposite = new Composite(parent, parent.getStyle());
        templateNameComposite.setLayout((Layout)new GridLayout(2, false));
        templateNameComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label templateNameLabel = new Label(templateNameComposite, parent.getStyle());
        templateNameLabel.setText("Template name:");
        this.templateNameText = new Text(templateNameComposite, parent.getStyle());
        if (this.defaultTempateName != null) {
            this.templateNameText.setText(this.defaultTempateName);
        }
        this.templateNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                M2DocNewTemplatePage.this.setTemplateName(M2DocNewTemplatePage.this.templateNameText.getText());
            }
        });
        this.templateNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocNewTemplatePage.this.setTemplateName(M2DocNewTemplatePage.this.templateNameText.getText());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.templateNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.setTemplateName(this.templateNameText.getText());
        this.setControl((Control)templateNameComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.newProjectPage != null && visible && (this.templateNameText.getText() == null || this.templateNameText.getText().isEmpty())) {
            this.templateNameText.setText(this.newProjectPage.getProjectName() + ".docx");
            this.validatePage(this.templateNameText.getText());
        }
    }

    private void validatePage(String name) {
        if (name.endsWith(".docx")) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("Template name must ends with \".docx\".");
            this.setPageComplete(false);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

