/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.io.IOException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.ui.M2DocUIPlugin;
import org.obeonetwork.m2doc.ide.ui.wizard.TemplateCustomPropertiesPage;
import org.obeonetwork.m2doc.ide.ui.wizard.TemplateVariablesPage;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.TokenRegistry;

public class TemplateCustomPropertiesWizard
extends Wizard {
    TemplateCustomPropertiesPage templateCustomPropertiesPage;
    TemplateVariablesPage templateVariablesProperties;
    XWPFDocument document;
    private final URI templateURI;
    private TemplateCustomProperties properties;

    public TemplateCustomPropertiesWizard(URI templateURI) {
        M2DocPlugin.getDefault();
        this.templateURI = templateURI;
    }

    public void addPages() {
        try {
            this.document = POIServices.getInstance().getXWPFDocument(URIConverter.INSTANCE, this.templateURI);
            this.properties = new TemplateCustomProperties(this.document);
            for (String missingVariable : this.properties.getMissingVariables()) {
                this.properties.getVariables().put(missingVariable, "");
            }
            for (String unusedVariable : this.properties.getUnusedDeclarations()) {
                this.properties.getVariables().remove(unusedVariable);
            }
            this.templateVariablesProperties = new TemplateVariablesPage(this.properties);
            this.templateCustomPropertiesPage = new TemplateCustomPropertiesPage(TokenRegistry.INSTANCE, this.properties, this.templateVariablesProperties);
            this.templateVariablesProperties.setWizardPage(this.templateCustomPropertiesPage);
            this.addPage((IWizardPage)this.templateCustomPropertiesPage);
            this.addPage((IWizardPage)this.templateVariablesProperties);
        }
        catch (Exception e) {
            this.addPage((IWizardPage)new WizardPage("Invalid template"){

                public void createControl(Composite parent) {
                    Composite container = new Composite(parent, parent.getStyle());
                    this.setControl((Control)container);
                    this.setErrorMessage("Template invalid: " + e.getMessage());
                    this.setPageComplete(false);
                }
            });
            M2DocUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.obeonetwork.m2doc.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    public boolean performFinish() {
        WorkspaceJob job = new WorkspaceJob("Saving template"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                Status status = new Status(0, "org.obeonetwork.m2doc.ide.ui", "Template saved succesfully");
                TemplateCustomPropertiesWizard.this.properties.save();
                try {
                    POIServices.getInstance().saveFile(URIConverter.INSTANCE, TemplateCustomPropertiesWizard.this.document, TemplateCustomPropertiesWizard.this.templateURI);
                    TemplateCustomPropertiesWizard.this.document.close();
                }
                catch (IOException e) {
                    status = new Status(4, "org.obeonetwork.m2doc.ide.ui", e.getMessage(), (Throwable)e);
                    M2DocUIPlugin.getDefault().getLog().log((IStatus)status);
                }
                return status;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }

    public boolean performCancel() {
        if (this.document != null) {
            try {
                this.document.close();
            }
            catch (IOException e) {
                M2DocUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.obeonetwork.m2doc.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
        return super.performCancel();
    }
}

