/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.jdt.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.jdt.M2DocJDTPlugin;
import org.obeonetwork.m2doc.ide.util.EclipseClassProvider;

public class EclipseJDTClassProvider
extends EclipseClassProvider {
    private Map<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] affectedChildren;
            IResourceDelta delta;
            if (event != null && (delta = event.getDelta()) != null && (affectedChildren = delta.getAffectedChildren()) != null) {
                IResourceDelta[] iResourceDeltaArray = affectedChildren;
                int n = affectedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta child = iResourceDeltaArray[n2];
                    EclipseJDTClassProvider.this.updateClassLoaderCache(child);
                    ++n2;
                }
            }
        }
    };

    public EclipseJDTClassProvider() {
        super(M2DocPlugin.getBundlerContext(), M2DocPlugin.getPlugin().getClass().getClassLoader());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    private void updateClassLoaderCache(IResourceDelta child) {
        IProject project;
        IResource resource = child.getResource();
        if (resource != null && (project = resource.getProject()) != null) {
            this.classLoaders.remove(project.getName());
        }
    }

    public Class<?> getClass(String className, String bundleName) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoaderForProject(bundleName);
        Class res = classLoader != null ? classLoader.loadClass(className) : super.getClass(className, bundleName);
        return res;
    }

    protected ClassLoader getClassLoaderForProject(String name) {
        ClassLoader res;
        ClassLoader cachedClassLoader = this.classLoaders.get(name);
        if (cachedClassLoader != null) {
            res = cachedClassLoader;
        } else {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists() && project.isOpen()) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null) {
                    try {
                        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                        ArrayList<URL> urlList = new ArrayList<URL>();
                        String[] stringArray = classPathEntries;
                        int n = classPathEntries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String entry = stringArray[n2];
                            Path path = new Path(entry);
                            URL url = path.toFile().toURI().toURL();
                            urlList.add(url);
                            ++n2;
                        }
                        URL[] urls = urlList.toArray(new URL[urlList.size()]);
                        res = new URLClassLoader(urls, this.getClassLoader());
                        this.classLoaders.put(name, res);
                    }
                    catch (CoreException e) {
                        M2DocJDTPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.obeonetwork.m2doc.ide.jdt", "can't load from workspace.", (Throwable)e));
                        res = null;
                    }
                    catch (MalformedURLException e) {
                        M2DocJDTPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.obeonetwork.m2doc.ide.jdt", "can't load from workspace.", (Throwable)e));
                        res = null;
                    }
                } else {
                    res = null;
                }
            } else {
                res = null;
            }
        }
        return res;
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        this.classLoaders.clear();
    }
}

