/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.editor.command.AbstractGenerationHandler;
import org.obeonetwork.m2doc.genconf.presentation.M2docconfEditorPlugin;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.util.IClassProvider;

public class ValidateHandler
extends AbstractGenerationHandler {
    @Override
    protected void execute(ExecutionEvent event, Generation generation) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ValidateJob job = new ValidateJob(generation, shell);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private final class ValidateJob
    extends WorkspaceJob {
        private static final String M2_DOC_VALIDATION = "M2Doc validation";
        private final Generation generation;
        private final Shell shell;

        private ValidateJob(Generation generation, Shell shell) {
            super("Validating " + URI.decode((String)generation.eResource().getURI().toString()));
            this.generation = generation;
            this.shell = shell;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Status status = new Status(0, M2docconfEditorPlugin.getPlugin().getSymbolicName(), "Generation configuration succesfully saved");
            try {
                boolean validate = ValidateHandler.checkM2DocVersion(this.shell, M2_DOC_VALIDATION, this.generation);
                if (validate) {
                    boolean inError = GenconfUtils.validate((Generation)this.generation, (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)BasicMonitor.toMonitor((IProgressMonitor)monitor));
                    if (!inError) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)ValidateJob.this.shell, (String)ValidateJob.M2_DOC_VALIDATION, (String)"The template validation has been performed successfully.");
                            }
                        });
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)ValidateJob.this.shell, (String)ValidateJob.M2_DOC_VALIDATION, (String)"Error(s) detected during validation. A log file has been generated next to the template file.");
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                M2docconfEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, M2docconfEditorPlugin.getPlugin().getSymbolicName(), 4, e.getMessage(), (Throwable)e));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)ValidateJob.this.shell, (String)"Can't save validation file.", (String)"Can't save validation file, see the error log for details and check if the file is not opened elsewhere.");
                    }
                });
            }
            return status;
        }
    }
}

