/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.dialog;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.Option;
import org.obeonetwork.m2doc.ide.ui.wizard.SelectRegisteredTemplatePage;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class M2DocOptionDialog
extends MessageDialog {
    private Generation generation;
    private Option option;
    private String optionName;
    private String optionValue;

    public M2DocOptionDialog(Shell parentShell, Generation generation, Option option) {
        super(parentShell, "Set option name and value.", null, "Set option name and value.", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.generation = generation;
        this.option = option;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ComboViewer combo = new ComboViewer(container, parent.getStyle());
        combo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        combo.setContentProvider((IContentProvider)new SelectRegisteredTemplatePage.CollectionContentProvider());
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                M2DocOptionDialog.this.optionName = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        List<String> possibleOptions = this.getPossibleOptions(this.generation, this.option);
        combo.setInput(possibleOptions);
        combo.setSelection((ISelection)new StructuredSelection((Object)this.option.getName()));
        final Text text = new Text(container, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                M2DocOptionDialog.this.optionValue = text.getText();
            }
        });
        if (this.option.getValue() != null) {
            text.setText(this.option.getValue());
        }
        return container;
    }

    private List<String> getPossibleOptions(Generation gen, Option opt) {
        List possibleOptions = M2DocUtils.getPossibleOptionNames();
        for (Option o : gen.getOptions()) {
            if (o == opt) continue;
            possibleOptions.remove(o.getName());
        }
        Collections.sort(possibleOptions);
        return possibleOptions;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionValue() {
        return this.optionValue;
    }
}

