/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryValidationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.editor.view.aql.AQLConfiguration;
import org.obeonetwork.m2doc.genconf.editor.view.aql.ColorManager;
import org.obeonetwork.m2doc.genconf.editor.view.aql.ProposalLabelProvider;
import org.obeonetwork.m2doc.generator.M2DocEvaluationEnvironment;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.M2DocTemplateService;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Parameter;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.util.HtmlSerializer;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class M2DocInterpreterView
extends ViewPart {
    private static final String IN_PROGRESS_HTML = M2DocInterpreterView.initInProgressHTML();
    private static final String VALIDATION_HTML_FORMAT = "<p onmouseover=\"highlight(%s,%s,%s);\" onmouseout=\"clearHighlight(%s,%s,%s);\" style=\"background-color: %s;\">%s: %s (%s, %s)</p>";
    private static final String GENCONF_URI = "genconfURI";
    private static final String EXPRESSION = "expression";
    private static final String SELECTION_VARIABLE = "selection";
    private IMemento memento;
    private final ColorManager colorManager = new ColorManager();
    private final ILabelProvider labelProvider = new ProposalLabelProvider();
    private Label genconfLabel;
    private SourceViewer sourceViewer;
    private Browser browser;
    private ISelectionListener updateSelectionListener;
    private final HtmlSerializer htmlSerializer = new HtmlSerializer();
    private IHandlerActivation contentAssistHandlerActivation;
    private final Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();
    private Map<String, Object> allVariables;
    private Object selectionValue;
    private IQueryEnvironment queryEnvironment;
    private ResourceSet resourceSetForModels;
    private IQueryValidationEngine validationEngine;
    private QueryEvaluationEngine evaluationEngine;
    private IQueryBuilderEngine queryBuilder;
    private Generation generation;
    private M2DocEvaluationEnvironment m2docEnv;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private Future<?> updatingFuture;

    public void init(IViewSite site, IMemento memo) throws PartInitException {
        super.init(site, memo);
        this.memento = memo;
    }

    private static String initInProgressHTML() {
        StringBuilder res = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = M2DocInterpreterView.class.getResourceAsStream("/icons/loader.gif");){
                res.append("<img style=\"display: block;margin-left: auto;margin-right: auto;width: 10%;\" src=\"");
                res.append("data:image/gif;base64, ");
                byte[] imageData = IOUtils.toByteArray((InputStream)stream);
                res.append(new String(Base64.getEncoder().encode(imageData)));
                res.append("\"/>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "";
        }
        return res.toString();
    }

    public void saveState(IMemento memo) {
        super.saveState(memo);
        if (this.getGenconfURI() != null) {
            memo.putString(GENCONF_URI, this.getGenconfURI().toString());
        }
        memo.putString(EXPRESSION, this.sourceViewer.getTextWidget().getText());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite sashComposite = new Composite(parent, 0);
        sashComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout sashLayout = new GridLayout(1, false);
        sashComposite.setLayout((Layout)sashLayout);
        this.genconfLabel = new Label(sashComposite, 2048);
        this.genconfLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        SashForm sashForm = new SashForm(sashComposite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sourceViewer = new SourceViewer((Composite)sashForm, (IVerticalRuler)new VerticalRuler(0), 2048);
        this.sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                M2DocInterpreterView.this.updateBrowser(M2DocInterpreterView.this.sourceViewer.getTextWidget().getText());
            }
        });
        this.browser = new Browser((Composite)sashForm, 2048);
        new HighlightFunction(this.browser, this.sourceViewer);
        new ClearHighlightFunction(this.browser, this.sourceViewer);
        sashForm.setWeights(new int[]{1, 5});
        if (this.memento != null) {
            String expression;
            String savedGenconfURI = this.memento.getString(GENCONF_URI);
            if (savedGenconfURI != null) {
                this.setGenconfURI(URI.createURI((String)savedGenconfURI));
            }
            if ((expression = this.memento.getString(EXPRESSION)) != null) {
                this.sourceViewer.setInput((Object)new Document(expression));
            } else {
                this.sourceViewer.setInput((Object)new Document(""));
            }
        } else {
            this.sourceViewer.setInput((Object)new Document(""));
        }
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.updateSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part != M2DocInterpreterView.this && M2DocInterpreterView.this.generation != null) {
                    LinkedHashSet<IType> selectionPossibleTypes = new LinkedHashSet<IType>();
                    if (selection instanceof IStructuredSelection) {
                        M2DocInterpreterView.this.selectionValue = M2DocInterpreterView.this.tryToAdaptToEObject(((IStructuredSelection)selection).getFirstElement());
                        selectionPossibleTypes.addAll(M2DocInterpreterView.this.getPossibleTypesForValue(M2DocInterpreterView.this.queryEnvironment, M2DocInterpreterView.this.selectionValue));
                    }
                    M2DocInterpreterView.this.variableTypes.put(M2DocInterpreterView.SELECTION_VARIABLE, selectionPossibleTypes);
                    if (M2DocInterpreterView.this.allVariables != null) {
                        M2DocInterpreterView.this.allVariables.put(M2DocInterpreterView.SELECTION_VARIABLE, M2DocInterpreterView.this.selectionValue);
                    }
                    M2DocInterpreterView.this.updateBrowser(M2DocInterpreterView.this.sourceViewer.getTextWidget().getText());
                }
            }
        };
        selectionService.addSelectionListener(this.updateSelectionListener);
        this.updateBrowser(this.sourceViewer.getTextWidget().getText());
    }

    private Object tryToAdaptToEObject(Object element) {
        Object adaptedElement;
        Object res = element instanceof EObject ? element : (element instanceof IAdaptable ? ((adaptedElement = ((IAdaptable)element).getAdapter(EObject.class)) != null ? adaptedElement : Platform.getAdapterManager().getAdapter(element, EObject.class)) : (element != null ? Platform.getAdapterManager().getAdapter(element, EObject.class) : null));
        if (res != null) {
            return res;
        }
        return element;
    }

    private Set<IType> getPossibleTypesForValue(IQueryEnvironment environment, Object object) {
        LinkedHashSet<IType> res = new LinkedHashSet<IType>();
        if (object instanceof EObject) {
            res.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)environment, (EClassifier)((EObject)object).eClass()));
        } else if (object != null) {
            res.add((IType)new ClassType((IReadOnlyQueryEnvironment)environment, object.getClass()));
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public void setGenconfURI(URI genconfURI) {
        this.browser.setText(M2DocInterpreterView.IN_PROGRESS_HTML);
        this.sourceViewer.unconfigure();
        if (this.generation != null) {
            for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
                configurator.cleanServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.resourceSetForModels);
            }
            try {
                if (this.m2docEnv != null) {
                    this.m2docEnv.getUserContentManager().dispose();
                }
            }
            catch (IOException configurator) {
                // empty catch block
            }
        }
        try {
            this.generation = GenconfUtils.getGeneration((URI)genconfURI);
            exceptions = new ArrayList<E>();
            this.resourceSetForModels = M2DocUtils.createResourceSetForModels(exceptions, (Object)this.generation, (ResourceSet)new ResourceSetImpl(), (Map)GenconfUtils.getOptions((Generation)this.generation));
            this.queryEnvironment = GenconfUtils.getQueryEnvironment((ResourceSet)this.resourceSetForModels, (Generation)this.generation);
            templateURI = GenconfUtils.getResolvedURI((Generation)this.generation, (URI)URI.createURI((String)this.generation.getTemplateFileName(), (boolean)false));
            classProvider = M2DocPlugin.getClassProvider();
            uriConverter = this.resourceSetForModels.getURIConverter();
            var6_8 = null;
            var7_10 = null;
            try {
                document = POIServices.getInstance().getXWPFDocument(this.resourceSetForModels.getURIConverter(), templateURI);
                try {
                    documentTemplate = M2DocUtils.parse((URIConverter)uriConverter, (URI)templateURI, (IQueryEnvironment)this.queryEnvironment, (IClassProvider)classProvider, (Monitor)new BasicMonitor());
                    try {
                        properties = new TemplateCustomProperties(document);
                        properties.configureQueryEnvironmentWithResult(this.queryEnvironment);
                        properties.configureQueryEnvironmentWithResult(this.queryEnvironment, classProvider);
                        if (!documentTemplate.getTemplates().isEmpty()) {
                            serializedDocument = M2DocInterpreterView.serializeDocument(documentTemplate);
                            this.m2docEnv = new M2DocEvaluationEnvironment((IReadOnlyQueryEnvironment)this.queryEnvironment, uriConverter, documentTemplate.eResource().getURI(), null);
                            for (Template template : documentTemplate.getTemplates()) {
                                this.queryEnvironment.registerService((IService)new M2DocTemplateService(template, serializedDocument, this.m2docEnv, (Monitor)new BasicMonitor()));
                            }
                        }
                        validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
                        this.variableTypes.clear();
                        this.variableTypes.put("selection", this.getPossibleTypesForValue(this.queryEnvironment, this.selectionValue));
                        this.variableTypes.putAll(properties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)this.queryEnvironment));
                        this.variableTypes.putAll(this.parseVariableTypes((IReadOnlyQueryEnvironment)this.queryEnvironment, validator, this.variableTypes, this.resourceSetForModels.getURIConverter(), templateURI));
                        this.validationEngine = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
                        this.evaluationEngine = new QueryEvaluationEngine(this.queryEnvironment);
                        variables = GenconfUtils.getVariables((Generation)this.generation, (ResourceSet)this.resourceSetForModels);
                        this.allVariables = new HashMap<String, Object>(variables);
                        this.allVariables.put("selection", this.selectionValue);
                        this.allVariables.putAll(this.parseVariableValues((IReadOnlyQueryEnvironment)this.queryEnvironment, this.evaluationEngine, this.allVariables, uriConverter, templateURI));
                        this.queryBuilder = new QueryBuilderEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
                    }
                    finally {
                        if (documentTemplate != null) {
                            documentTemplate.close();
                        }
                    }
                    ** if (document == null) goto lbl-1000
                }
                catch (Throwable var7_11) {
                    if (var6_8 == null) {
                        var6_8 = var7_11;
                    } else if (var6_8 != var7_11) {
                        var6_8.addSuppressed(var7_11);
                    }
                    if (document != null) {
                        document.close();
                    }
                    throw var6_8;
                }
lbl-1000:
                // 1 sources

                {
                    document.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var7_12) {
                if (var6_8 == null) {
                    var6_8 = var7_12;
                } else if (var6_8 != var7_12) {
                    var6_8.addSuppressed(var7_12);
                }
                throw var6_8;
            }
            configuration = new AQLConfiguration(this.colorManager, this.labelProvider, (IReadOnlyQueryEnvironment)this.queryEnvironment, this.variableTypes);
            this.sourceViewer.configure((SourceViewerConfiguration)configuration);
            this.setUpContentAssist(configuration.getContentAssistant((ISourceViewer)this.sourceViewer));
            for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
                configurator.startGeneration((IReadOnlyQueryEnvironment)this.queryEnvironment, new XWPFDocument());
            }
            if (this.generation != null) {
                this.genconfLabel.setText(URI.decode((String)genconfURI.toString()));
            } else {
                this.genconfLabel.setText("");
            }
            this.updateBrowser(this.sourceViewer.getTextWidget().getText());
        }
        catch (Exception e) {
            this.browser.setText(this.htmlSerializer.serialize((Object)("can't load .genconf file: " + e.getMessage())));
            this.genconfLabel.setText("can't load .genconf file");
            this.generation = null;
            this.m2docEnv = null;
        }
    }

    private static byte[] serializeDocument(DocumentTemplate documentTemplate) throws IOException {
        byte[] serializedDocument;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            documentTemplate.getDocument().write((OutputStream)output);
            serializedDocument = output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return serializedDocument;
    }

    public URI getGenconfURI() {
        URI res = this.generation != null ? this.generation.eResource().getURI() : null;
        return res;
    }

    protected final void setUpContentAssist(final IContentAssistant assistant) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.contentAssistHandlerActivation != null) {
            service.deactivateHandler(this.contentAssistHandlerActivation);
        }
        Action contentAssistAction = new Action(){

            public void run() {
                assistant.showPossibleCompletions();
            }
        };
        ActionHandler contentAssistHandler = new ActionHandler((IAction)contentAssistAction);
        this.contentAssistHandlerActivation = service.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)contentAssistHandler);
    }

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
        this.labelProvider.dispose();
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        service.deactivateHandler(this.contentAssistHandlerActivation);
        this.browser.dispose();
        if (this.genconfLabel != null) {
            this.genconfLabel.dispose();
        }
        if (this.sourceViewer != null && this.sourceViewer.getTextWidget() != null) {
            this.sourceViewer.getTextWidget().dispose();
        }
        if (this.updateSelectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.updateSelectionListener);
        }
    }

    public void setFocus() {
        if (this.sourceViewer != null) {
            this.sourceViewer.getControl().setFocus();
        }
    }

    private void updateBrowser(String expression) {
        this.executorService.shutdownNow();
        if (this.updatingFuture != null && !this.updatingFuture.isDone()) {
            this.updatingFuture.cancel(true);
        }
        this.executorService = Executors.newFixedThreadPool(1);
        this.updatingFuture = this.executorService.submit(new UpdateBrowserRunnable(expression));
    }

    private String getValidationHTMLContent(IValidationResult validationResult) {
        StringBuilder res = new StringBuilder();
        if (!validationResult.getMessages().isEmpty()) {
            for (IValidationMessage message : validationResult.getMessages()) {
                switch (message.getLevel()) {
                    case INFO: {
                        res.append(String.format(VALIDATION_HTML_FORMAT, "'INFO'", message.getStartPosition(), message.getEndPosition(), "'INFO'", message.getStartPosition(), message.getEndPosition(), "cyan", "INFO", message.getMessage(), message.getStartPosition(), message.getEndPosition()));
                        break;
                    }
                    case WARNING: {
                        res.append(String.format(VALIDATION_HTML_FORMAT, "'WARNING'", message.getStartPosition(), message.getEndPosition(), "'WARNING'", message.getStartPosition(), message.getEndPosition(), "yellow", "WARNING", message.getMessage(), message.getStartPosition(), message.getEndPosition()));
                        break;
                    }
                    case ERROR: {
                        res.append(String.format(VALIDATION_HTML_FORMAT, "'ERROR'", message.getStartPosition(), message.getEndPosition(), "'ERROR'", message.getStartPosition(), message.getEndPosition(), "red", "ERROR", message.getMessage(), message.getStartPosition(), message.getEndPosition()));
                        break;
                    }
                }
            }
            res.append("<hr>");
        }
        return res.toString();
    }

    private Map<String, Set<IType>> parseVariableTypes(IReadOnlyQueryEnvironment env, AstValidator validator, Map<String, Set<IType>> varTypes, URIConverter uriConv, URI tpltURI) {
        HashMap<String, Set<IType>> res = new HashMap<String, Set<IType>>();
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (DocumentTemplate template = M2DocUtils.parse((URIConverter)uriConv, (URI)tpltURI, (IQueryEnvironment)((IQueryEnvironment)env), (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)new BasicMonitor());){
                TreeIterator it = template.eAllContents();
                while (it.hasNext()) {
                    Parameter parameter;
                    Set possibleTypes;
                    IValidationResult validationResult;
                    EObject current = (EObject)it.next();
                    if (current instanceof Let) {
                        Let let = (Let)current;
                        if (let.getName() == null) continue;
                        validationResult = validator.validate(varTypes, let.getValue());
                        possibleTypes = validationResult.getPossibleTypes(let.getValue().getAst());
                        res.put(let.getName(), possibleTypes);
                        continue;
                    }
                    if (current instanceof Repetition) {
                        Repetition repetition = (Repetition)current;
                        if (repetition.getIterationVar() == null) continue;
                        validationResult = validator.validate(varTypes, repetition.getQuery());
                        possibleTypes = validationResult.getPossibleTypes(repetition.getQuery().getAst());
                        res.put(repetition.getIterationVar(), possibleTypes);
                        LinkedHashSet<ClassType> indexTypes = new LinkedHashSet<ClassType>();
                        indexTypes.add(new ClassType(env, Integer.class));
                        res.put(repetition.getIterationVar() + "Index", indexTypes);
                        continue;
                    }
                    if (!(current instanceof Parameter) || (parameter = (Parameter)current).getName() == null) continue;
                    validationResult = validator.validate(varTypes, parameter.getType());
                    possibleTypes = validationResult.getPossibleTypes(parameter.getType().getAst());
                    res.put(parameter.getName(), possibleTypes);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
        }
        catch (DocumentParserException documentParserException) {
            // empty catch block
        }
        return res;
    }

    private Map<String, Object> parseVariableValues(IReadOnlyQueryEnvironment env, QueryEvaluationEngine engine, Map<String, Object> variables, URIConverter uriConverter, URI tpltURI) {
        HashMap<String, Object> res = new HashMap<String, Object>(variables);
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (DocumentTemplate template = M2DocUtils.parse((URIConverter)uriConverter, (URI)tpltURI, (IQueryEnvironment)((IQueryEnvironment)env), (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)new BasicMonitor());){
                TreeIterator it = template.eAllContents();
                while (it.hasNext()) {
                    EObject current = (EObject)it.next();
                    if (current instanceof Let) {
                        Let let = (Let)current;
                        if (let.getName() == null) continue;
                        EvaluationResult evaluationResult = engine.eval(let.getValue(), res);
                        Object value = evaluationResult.getResult();
                        res.put(let.getName(), value);
                        continue;
                    }
                    if (current instanceof Repetition) {
                        Repetition repetition = (Repetition)current;
                        this.getRepetitionVariableValues(res, engine, repetition);
                        continue;
                    }
                    boolean cfr_ignored_0 = current instanceof Parameter;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
        }
        catch (DocumentParserException documentParserException) {
            // empty catch block
        }
        return res;
    }

    private void getRepetitionVariableValues(Map<String, Object> res, QueryEvaluationEngine engine, Repetition repetition) {
        Iterator valIt;
        EvaluationResult evaluationResult = engine.eval(repetition.getQuery(), res);
        Object value = evaluationResult.getResult();
        if (value != null && (valIt = ((Collection)value).iterator()).hasNext() && repetition.getIterationVar() != null) {
            res.put(repetition.getIterationVar(), valIt.next());
        }
        res.put(repetition.getIterationVar() + "Index", 1);
    }

    private static final class ClearHighlightFunction
    extends BrowserFunction {
        private static final String NAME = "clearHighlight";
        private SourceViewer sourceViewer;

        private ClearHighlightFunction(Browser browser, SourceViewer sourceViewer) {
            super(browser, NAME);
            this.sourceViewer = sourceViewer;
        }

        public Object function(Object[] arguments) {
            int start = ((Double)arguments[1]).intValue();
            int length = ((Double)arguments[2]).intValue() - start;
            this.sourceViewer.getTextWidget().setStyleRange(new StyleRange(start, length, null, null));
            return null;
        }
    }

    private static final class HighlightFunction
    extends BrowserFunction {
        private static final String NAME = "highlight";
        private SourceViewer sourceViewer;

        private HighlightFunction(Browser browser, SourceViewer sourceViewer) {
            super(browser, NAME);
            this.sourceViewer = sourceViewer;
        }

        public Object function(Object[] arguments) {
            Display display = Display.getDefault();
            int start = ((Double)arguments[1]).intValue();
            int length = ((Double)arguments[2]).intValue() - start;
            switch ((String)arguments[0]) {
                case "INFO": {
                    this.sourceViewer.getTextWidget().setStyleRange(new StyleRange(start, length, null, display.getSystemColor(13)));
                    break;
                }
                case "WARNING": {
                    this.sourceViewer.getTextWidget().setStyleRange(new StyleRange(start, length, null, display.getSystemColor(7)));
                    break;
                }
                case "ERROR": {
                    this.sourceViewer.getTextWidget().setStyleRange(new StyleRange(start, length, null, display.getSystemColor(3)));
                    break;
                }
            }
            return null;
        }
    }

    private final class UpdateBrowserRunnable
    implements Runnable {
        private final String expression;

        private UpdateBrowserRunnable(String expression) {
            this.expression = expression;
        }

        @Override
        public void run() {
            Object html;
            if (!Thread.interrupted()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((UpdateBrowserRunnable)UpdateBrowserRunnable.this).M2DocInterpreterView.this.browser.setText(IN_PROGRESS_HTML);
                    }
                });
            }
            if (M2DocInterpreterView.this.generation != null) {
                String evaluationContent;
                if (M2DocInterpreterView.this.m2docEnv != null) {
                    M2DocInterpreterView.this.m2docEnv.getBookmarkManager().reset();
                    M2DocInterpreterView.this.m2docEnv.getUserContentManager().reset();
                }
                IValidationResult validationResult = M2DocInterpreterView.this.validationEngine.validate(this.expression, M2DocInterpreterView.this.variableTypes);
                String validationContent = M2DocInterpreterView.this.getValidationHTMLContent(validationResult);
                if (!this.hasError(validationResult)) {
                    IQueryBuilderEngine.AstResult astBuilder = M2DocInterpreterView.this.queryBuilder.build(this.expression);
                    EvaluationResult evaluationResult = M2DocInterpreterView.this.evaluationEngine.eval(astBuilder, M2DocInterpreterView.this.allVariables);
                    evaluationContent = M2DocInterpreterView.this.htmlSerializer.serialize(evaluationResult.getResult());
                } else {
                    evaluationContent = "";
                }
                html = validationContent + evaluationContent;
            } else {
                html = "You need to select a generation model (.genconf file).";
            }
            if (!Thread.interrupted()) {
                Display.getDefault().syncExec(new Runnable((String)html){
                    private final /* synthetic */ String val$html;
                    {
                        this.val$html = string;
                    }

                    @Override
                    public void run() {
                        ((UpdateBrowserRunnable)UpdateBrowserRunnable.this).M2DocInterpreterView.this.browser.setText(this.val$html);
                    }
                });
            }
        }

        private boolean hasError(IValidationResult validationResult) {
            for (IValidationMessage message : validationResult.getMessages()) {
                if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
                return true;
            }
            return false;
        }
    }
}

