/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.view.aql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class AQLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos >= 0) {
            this.selectWord(part, pos);
        }
    }

    protected boolean selectWord(ITextViewer text, int caretPos) {
        boolean res;
        IDocument doc = text.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(text, startPos, endPos);
            res = true;
        }
        catch (BadLocationException x) {
            res = false;
        }
        return res;
    }

    private void selectRange(ITextViewer text, int start, int stop) {
        int offset = start + 1;
        int length = stop - offset;
        text.setSelectedRange(offset, length);
    }
}

