/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.obeonetwork.m2doc.ide.ui.dialog.M2DocFileSelectionDialog;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocMainVariablePage;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocNewTemplatePage;

public class M2DocGenerationPage
extends WizardPage {
    private static final int PREFIX_LENGTH = "/resource".length();
    private static final String DOT = ".";
    private static final String BROWSE = "Browse";
    private String generationName;
    private String destinationName;
    private String validationName;
    private boolean launchGeneration;
    private M2DocNewTemplatePage newTemplatePage;
    private final M2DocMainVariablePage mainVariablePage;
    private Text generationNameText;
    private Text destinationNameText;
    private Text validationNameText;

    protected M2DocGenerationPage(M2DocNewTemplatePage newTemplatePage, M2DocMainVariablePage mainVariablePage) {
        super("Configure generation.");
        this.newTemplatePage = newTemplatePage;
        this.mainVariablePage = mainVariablePage;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, parent.getStyle());
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        this.generationNameText = this.createGenerationNameComposite(pageComposite);
        this.destinationNameText = this.createDestinationNameComposite(pageComposite);
        this.validationNameText = this.createValidationNameComposite(pageComposite);
        this.createLaunchGenerationComposite(pageComposite);
        this.validatePage();
        this.setControl((Control)pageComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            URI modelURI = URI.createURI((String)URI.decode((String)this.mainVariablePage.getVariableValue().eResource().getURI().toString()));
            String templateName = new Path(this.newTemplatePage.getTemplateName()).removeFileExtension().lastSegment();
            if (this.generationName == null) {
                this.generationName = URI.createURI((String)(templateName + ".genconf")).resolve(modelURI).path().substring(PREFIX_LENGTH);
                this.generationNameText.setText(this.generationName);
            }
            if (this.destinationName == null) {
                this.destinationName = URI.createURI((String)(templateName + "-result.docx")).resolve(modelURI).path().substring(PREFIX_LENGTH);
                this.destinationNameText.setText(this.destinationName);
            }
            if (this.validationName == null) {
                this.validationName = URI.createURI((String)(templateName + "-validation.docx")).resolve(modelURI).path().substring(PREFIX_LENGTH);
                this.validationNameText.setText(this.validationName);
            }
            this.validatePage();
        }
    }

    private Button createLaunchGenerationComposite(Composite composite) {
        Composite launchComposite = new Composite(composite, composite.getStyle());
        launchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        launchComposite.setLayout((Layout)new GridLayout(1, false));
        Button launchButton = new Button(launchComposite, 32);
        launchButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        launchButton.setText("launch generation on finish");
        launchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                M2DocGenerationPage.this.launchGeneration = !M2DocGenerationPage.this.launchGeneration;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return launchButton;
    }

    private Text createGenerationNameComposite(Composite composite) {
        Composite generationNameComposite = new Composite(composite, composite.getStyle());
        generationNameComposite.setLayout((Layout)new GridLayout(3, false));
        generationNameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label generationNameLabel = new Label(generationNameComposite, composite.getStyle());
        generationNameLabel.setText("Generation file:");
        final Text res = new Text(generationNameComposite, composite.getStyle());
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        res.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocGenerationPage.this.generationName = res.getText();
                M2DocGenerationPage.this.validatePage();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button uriButton = new Button(generationNameComposite, 2048);
        uriButton.setText(BROWSE);
        uriButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(M2DocGenerationPage.this.getShell(), "Select generation file.", M2DocGenerationPage.this.generationName, "genconf", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    M2DocGenerationPage.this.generationName = dialog.getFileName();
                    M2DocGenerationPage.this.validatePage();
                }
            }
        });
        return res;
    }

    private Text createDestinationNameComposite(Composite composite) {
        Composite destinationNameComposite = new Composite(composite, composite.getStyle());
        destinationNameComposite.setLayout((Layout)new GridLayout(3, false));
        destinationNameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label destinationNameLabel = new Label(destinationNameComposite, composite.getStyle());
        destinationNameLabel.setText("Result file:");
        final Text res = new Text(destinationNameComposite, composite.getStyle());
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        res.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocGenerationPage.this.destinationName = res.getText();
                M2DocGenerationPage.this.validatePage();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button uriButton = new Button(destinationNameComposite, 2048);
        uriButton.setText(BROWSE);
        uriButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(M2DocGenerationPage.this.getShell(), "Select result file.", M2DocGenerationPage.this.destinationName, "docx", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    M2DocGenerationPage.this.destinationName = dialog.getFileName();
                    M2DocGenerationPage.this.validatePage();
                }
            }
        });
        return res;
    }

    private Text createValidationNameComposite(Composite composite) {
        Composite validationNameComposite = new Composite(composite, composite.getStyle());
        validationNameComposite.setLayout((Layout)new GridLayout(3, false));
        validationNameComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label validationNameLabel = new Label(validationNameComposite, composite.getStyle());
        validationNameLabel.setText("Validation file:");
        final Text res = new Text(validationNameComposite, composite.getStyle());
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        res.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocGenerationPage.this.validationName = res.getText();
                M2DocGenerationPage.this.validatePage();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button uriButton = new Button(validationNameComposite, 2048);
        uriButton.setText(BROWSE);
        uriButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2DocFileSelectionDialog dialog = new M2DocFileSelectionDialog(M2DocGenerationPage.this.getShell(), "Select validation file.", M2DocGenerationPage.this.validationName, "docx", false);
                int dialogResult = dialog.open();
                if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
                    M2DocGenerationPage.this.validationName = dialog.getFileName();
                    M2DocGenerationPage.this.validatePage();
                }
            }
        });
        return res;
    }

    private void validatePage() {
        if (this.generationName == null) {
            this.setErrorMessage("The generation configuration file must be defined.");
            this.setPageComplete(false);
        } else if (!this.generationName.endsWith(".genconf")) {
            this.setErrorMessage(String.format("The generation configuration file must ends with \".%s\".", "genconf"));
            this.setPageComplete(false);
        } else if (this.destinationName == null) {
            this.setErrorMessage("The result file must be defined.");
            this.setPageComplete(false);
        } else if (!this.destinationName.endsWith(".docx")) {
            this.setErrorMessage(String.format("The result file must ends with \".%s\".", "docx"));
            this.setPageComplete(false);
        } else if (this.validationName == null) {
            this.setErrorMessage("The result file must be defined.");
            this.setPageComplete(false);
        } else if (!this.validationName.endsWith(".docx")) {
            this.setErrorMessage(String.format("The validation file must ends with \".%s\".", "docx"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getGenerationName() {
        return this.generationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getValidationName() {
        return this.validationName;
    }

    public boolean getLaunchGeneration() {
        return this.launchGeneration;
    }
}

