/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.editor.wizard.M2DocGenerationPage;
import org.obeonetwork.m2doc.genconf.presentation.M2docconfEditorPlugin;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocMainVariablePage;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocNewTemplatePage;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.obeonetwork.m2doc.util.MemoryURIHandler;

public class M2DocNewProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage newProjectPage;
    private M2DocNewTemplatePage newTemplatePage;
    private M2DocMainVariablePage variablePage;
    private M2DocGenerationPage generationPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.newProjectPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.addPage((IWizardPage)this.newProjectPage);
        this.newTemplatePage = new M2DocNewTemplatePage(this.newProjectPage);
        this.addPage((IWizardPage)this.newTemplatePage);
        this.variablePage = new M2DocMainVariablePage();
        this.addPage((IWizardPage)this.variablePage);
        this.generationPage = new M2DocGenerationPage(this.newTemplatePage, this.variablePage);
        this.addPage((IWizardPage)this.generationPage);
    }

    public boolean performFinish() {
        String projectName = this.newProjectPage.getProjectName();
        String templateName = this.newTemplatePage.getTemplateName();
        String variableName = this.variablePage.getVariableName();
        EObject variableValue = this.variablePage.getVariableValue();
        URI genconfURI = URI.createPlatformResourceURI((String)this.generationPage.getGenerationName(), (boolean)true);
        URI destinationURI = URI.createPlatformResourceURI((String)this.generationPage.getDestinationName(), (boolean)true);
        URI validationURI = URI.createPlatformResourceURI((String)this.generationPage.getValidationName(), (boolean)true);
        boolean launchGeneration = this.generationPage.getLaunchGeneration();
        FinishJob job = new FinishJob("Creating M2Doc project: " + projectName, variableValue, variableName, launchGeneration, projectName, templateName, genconfURI, destinationURI, validationURI);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }

    private URI createSampleTemplate(String templateName, String variableName, EObject variableValue, IProgressMonitor monitor, IProject project) throws IOException, CoreException, InvalidFormatException {
        URI res;
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        MemoryURIHandler handler = new MemoryURIHandler();
        uriConverter.getURIHandlers().add(0, (Object)handler);
        Throwable throwable = null;
        Object var10_10 = null;
        try (XWPFDocument sampleTemplate = M2DocUtils.createSampleTemplate((String)variableName, (EClass)variableValue.eClass());){
            URI memoryURI = URI.createURI((String)"m2docmemory://resources/temp.docx");
            POIServices.getInstance().saveFile((URIConverter)uriConverter, sampleTemplate, memoryURI);
            Throwable throwable2 = null;
            Object var14_16 = null;
            try (InputStream source = uriConverter.createInputStream(memoryURI);){
                IFile templateFile = project.getFile(templateName);
                templateFile.create(source, true, monitor);
                res = URI.createPlatformResourceURI((String)templateFile.getFullPath().toString(), (boolean)true);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return res;
    }

    private Generation createGenconf(URI genconfURI, URI destinationURI, URI validationURI, URI templateURI, String variableName, EObject variableValue) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getURIConverter().exists(genconfURI, null) ? resourceSet.getResource(genconfURI, true) : resourceSet.createResource(URI.createURI((String)URI.decode((String)genconfURI.toString())));
        Generation res = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
        resource.getContents().clear();
        resource.getContents().add((Object)res);
        res.setTemplateFileName(URI.decode((String)templateURI.deresolve(genconfURI).toString()));
        res.setResultFileName(URI.decode((String)destinationURI.deresolve(genconfURI).toString()));
        res.setValidationFileName(URI.decode((String)validationURI.deresolve(genconfURI).toString()));
        ModelDefinition variableDefinition = GenconfPackage.eINSTANCE.getGenconfFactory().createModelDefinition();
        res.getDefinitions().add((Object)variableDefinition);
        variableDefinition.setKey(variableName);
        variableDefinition.setValue(resourceSet.getEObject(EcoreUtil.getURI((EObject)variableValue), true));
        GenconfUtils.initializeOptions((Generation)res);
        resource.save(null);
        return res;
    }

    private final class FinishJob
    extends WorkspaceJob {
        private final EObject variableValue;
        private final String variableName;
        private final boolean launchGeneration;
        private final String projectName;
        private final String templateName;
        private final URI genconfURI;
        private final URI destinationURI;
        private final URI validationURI;

        private FinishJob(String name, EObject variableValue, String variableName, boolean launchGeneration, String projectName, String templateName, URI genconfURI, URI destinationURI, URI validationURI) {
            super(name);
            this.variableValue = variableValue;
            this.variableName = variableName;
            this.launchGeneration = launchGeneration;
            this.projectName = projectName;
            this.templateName = templateName;
            this.genconfURI = genconfURI;
            this.destinationURI = destinationURI;
            this.validationURI = validationURI;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Status status = new Status(0, M2docconfEditorPlugin.getPlugin().getSymbolicName(), "M2Doc project " + this.projectName + " created succesfully.");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            project.create(monitor);
            project.open(monitor);
            try {
                URI templateURI = M2DocNewProjectWizard.this.createSampleTemplate(this.templateName, this.variableName, this.variableValue, monitor, project);
                Generation generation = M2DocNewProjectWizard.this.createGenconf(this.genconfURI, this.destinationURI, this.validationURI, templateURI, this.variableName, this.variableValue);
                if (this.launchGeneration) {
                    GenconfUtils.generate((Generation)generation, (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)BasicMonitor.toMonitor((IProgressMonitor)monitor));
                }
            }
            catch (IOException | InvalidFormatException | CoreException | DocumentGenerationException | DocumentParserException e) {
                status = new Status(4, M2docconfEditorPlugin.getPlugin().getSymbolicName(), "M2Doc project " + this.projectName + " creation failed.", e);
            }
            return status;
        }
    }
}

