/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.capella.m2doc.aql.queries;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MTable;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.SemanticBrowserHelper;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.diagram.helpers.RepresentationAnnotationHelper;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

@ServiceProvider(value="Services available for Capella extensions.")
public class M2DocGenServices
extends AbstractServiceProvider {
    private static final Pattern HLINK_WITH_UUID_PATTERN = Pattern.compile("hlink://_?([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})/?");
    private static final int UUID_GROUP = 1;

    @Documentation(value="Return recursively all the interface subpackages of the given interface packages.", params={@Param(name="interfacePkg", value="The given interface package")}, result="a list of all interface subpackages", examples={@Example(expression="myInterfacePkg.getInterfaceSubPkg()", result="a list of all interface subpackages")})
    public List<InterfacePkg> getInterfaceSubPkg(InterfacePkg interfacePkg) {
        HashSet<InterfacePkg> packages = new HashSet<InterfacePkg>();
        EList ownedInterfacePkgs = interfacePkg.getOwnedInterfacePkgs();
        for (InterfacePkg interfacePkg2 : ownedInterfacePkgs) {
            packages.add(interfacePkg2);
            List<InterfacePkg> allInterfacePackages = this.getInterfaceSubPkg(interfacePkg2);
            packages.addAll(allInterfacePackages);
        }
        return new ArrayList<InterfacePkg>(packages);
    }

    @Documentation(value="Compute the amount of contained interface subpackages.", params={@Param(name="interfacePkg", value="The given interface package")}, result="the number of contained interface subpackages", examples={@Example(expression="myInterfacePkg.getAllSubInterfacesCount()", result="the number of contained interface subpackages")})
    public int getAllSubInterfacesCount(InterfacePkg interfacePkg) {
        List<InterfacePkg> interfaceSubPkg = this.getInterfaceSubPkg(interfacePkg);
        int interfaceCount = 0;
        for (InterfacePkg interfacePkg2 : interfaceSubPkg) {
            interfaceCount += interfacePkg2.getOwnedInterfaces().size();
        }
        return interfaceCount;
    }

    @Documentation(value="Return recursively all the data subpackages of the given data package.", params={@Param(name="dataPkg", value="The given data package")}, result="a list of all data subpackages", examples={@Example(expression="myDataPkg.getAllDataPkgs()", result="a list of all data subpackages")})
    public List<DataPkg> getAllDataPkgs(DataPkg dataPkg) {
        HashSet<DataPkg> packages = new HashSet<DataPkg>();
        EList ownedDataPkgs = dataPkg.getOwnedDataPkgs();
        for (DataPkg dataPkg2 : ownedDataPkgs) {
            packages.add(dataPkg2);
            List<DataPkg> allDataPackages = this.getAllDataPkgs(dataPkg2);
            packages.addAll(allDataPackages);
        }
        return new ArrayList<DataPkg>(packages);
    }

    @Documentation(value="Compute a \"qualified name\" of the given data package. The root of the qualified name is the upper level data package.", params={@Param(name="dataPkg", value="The given data package")}, result="the qualified name of the data package", examples={@Example(expression="myDataPkg.getDataPkgQualifiedName()", result="the qualified name of the data package")})
    public String getDataPkgQualifiedName(DataPkg dataPkg) {
        EObject eContainer = dataPkg.eContainer();
        String name = "";
        if (eContainer instanceof DataPkg) {
            String containerName = this.getDataPkgQualifiedName((DataPkg)eContainer);
            name = String.valueOf(containerName) + ".";
        }
        name = String.valueOf(name) + dataPkg.getName();
        return name;
    }

    @Documentation(value="Return the component exchange direction (UNSET/IN/OUT/INOUT) for the given component.", params={@Param(name="ce", value="The given component exchange"), @Param(name="component", value="The given component")}, result="the component exchange direction (UNSET/IN/OUT/INOUT)", examples={@Example(expression="myDataPkg.getDataPkgQualifiedName(myComponent)", result="'UNSET' or 'IN' or 'OUT' or 'INOUT'")})
    public String getCeDirection(ComponentExchange ce, Component component) {
        Component sourceCeComponent = (Component)ce.getSourcePort().eContainer();
        Component targetCeComponent = (Component)ce.getTargetPort().eContainer();
        Port port = null;
        if (sourceCeComponent == component) {
            port = ce.getSourcePort();
        } else if (targetCeComponent == component) {
            port = ce.getTargetPort();
        }
        if (port instanceof ComponentPort) {
            ComponentPort cp = (ComponentPort)port;
            return cp.getOrientation().toString();
        }
        return "";
    }

    @Documentation(value="Return the component at the other end of the given component exchange and component.", params={@Param(name="ce", value="The given component exchange"), @Param(name="component", value="The given component")}, result="the component at the other end of the given component exchange and component", examples={@Example(expression="myDataPkg.getDataPkgQualifiedName(myComponent)", result="the component at the other end of the given component exchange and component")})
    public String getDestinationComponent(ComponentExchange ce, Component component) {
        Component sourceCeComponent = (Component)ce.getSourcePort().eContainer();
        Component targetCeComponent = (Component)ce.getTargetPort().eContainer();
        Port port = null;
        if (sourceCeComponent == component) {
            port = ce.getTargetPort();
        } else if (targetCeComponent == component) {
            port = ce.getSourcePort();
        }
        return ((Component)port.eContainer()).getName();
    }

    @Documentation(value="Replace the MLink uri from the given MElement to reference document bookmarks.", params={@Param(name="element", value="The given MElement"), @Param(name="reference", value="a reference EObject to reteive the Sirius Session")}, result="replaced the MLink uri from the given MElement to reference document bookmarks", examples={@Example(expression="myMElement.replaceLink(eObj)", result="replaced the MLink uri from the given MElement to reference document bookmarks")})
    public MElement replaceLink(MElement element, EObject reference) {
        Object res;
        if (element instanceof MList) {
            ArrayList<MElement> newElements = new ArrayList<MElement>();
            for (MElement e : (MList)element) {
                newElements.add(this.replaceLink(e, reference));
            }
            ((MList)element).clear();
            ((MList)element).addAll(newElements);
            res = element;
        } else if (element instanceof MParagraph) {
            MElement newContent = this.replaceLink(((MParagraph)element).getContents(), reference);
            if (newContent != ((MParagraph)element).getContents()) {
                ((MParagraph)element).setContents(newContent);
            }
            res = element;
        } else if (element instanceof MTable) {
            for (MTable.MRow row : ((MTable)element).getRows()) {
                for (MTable.MCell cell : row.getCells()) {
                    MElement newContent = this.replaceLink(cell.getContents(), reference);
                    if (newContent == cell.getContents()) continue;
                    cell.setContents(newContent);
                }
            }
            res = element;
        } else {
            res = element instanceof MHyperLink ? this.internalReplaceLink((MHyperLink)element, reference) : element;
        }
        return res;
    }

    private MHyperLink internalReplaceLink(MHyperLink link, EObject reference) {
        MHyperLink res;
        if (link.getUrl().startsWith("hlink://_") && link.getUrl().endsWith("/")) {
            String repID = link.getUrl().substring("hlink://".length(), link.getUrl().length() - 1);
            EObject repEObject = this.getLinkTargetFromId(reference, repID);
            if (repEObject instanceof DSemanticDecorator) {
                DSemanticDecorator decorator = (DSemanticDecorator)repEObject;
                EObject eObject = decorator.getTarget();
                res = this.internalReplaceLinkWithModelElementId(link, eObject);
            } else {
                res = link;
            }
        } else {
            Matcher matcher = HLINK_WITH_UUID_PATTERN.matcher(link.getUrl());
            if (matcher.matches()) {
                String id = matcher.group(1);
                EObject repEObject = this.getLinkTargetFromId(reference, id);
                if (repEObject instanceof DSemanticDecorator) {
                    DSemanticDecorator decorator = (DSemanticDecorator)repEObject;
                    EObject eObject = decorator.getTarget();
                    res = this.internalReplaceLinkWithModelElementId(link, eObject);
                } else {
                    Resource capellaResource = this.getCapellaResource(reference);
                    if (capellaResource != null) {
                        EObject eObject = capellaResource.getEObject(id);
                        res = this.internalReplaceLinkWithModelElementId(link, eObject);
                    } else {
                        res = link;
                    }
                }
            } else {
                res = link;
            }
        }
        return res;
    }

    private EObject getLinkTargetFromId(EObject reference, String id) {
        Session session = new EObjectQuery(reference).getSession();
        EObject repEObject = null;
        if (session != null && !StringUtil.isEmpty((String)id)) {
            Resource airResource = session.getSessionResource();
            repEObject = airResource.getEObject(id);
            if (repEObject == null) {
                for (Resource otherAirds : session.getReferencedSessionResources()) {
                    repEObject = otherAirds.getEObject(id);
                    if (repEObject != null) break;
                }
            }
            if (repEObject == null) {
                for (Resource srmResource : session.getSrmResources()) {
                    repEObject = srmResource.getEObject(id);
                    if (repEObject != null) break;
                }
            }
            if (repEObject == null) {
                for (DRepresentationDescriptor repDesc : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
                    DRepresentation rep;
                    ResourceDescriptor representationPath = repDesc.getRepPath();
                    if (!representationPath.getResourceURI().toString().contains(id) || (rep = repDesc.getRepresentation()) == null || !id.equals(rep.getUid())) continue;
                    repEObject = rep;
                    break;
                }
            }
        }
        return repEObject;
    }

    private MHyperLink internalReplaceLinkWithModelElementId(MHyperLink link, EObject eObject) {
        MHyperLink res;
        if (eObject instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)eObject;
            link.setUrl("#" + modelElement.getId());
            res = link;
        } else {
            res = link;
        }
        return res;
    }

    private Resource getCapellaResource(EObject reference) {
        Resource res = null;
        Session session = new EObjectQuery(reference).getSession();
        for (Resource resource : session.getSemanticResources()) {
            if (!"capella".equals(resource.getURI().fileExtension())) continue;
            res = resource;
            break;
        }
        return res;
    }

    @Documentation(value="Reduces all MImages from the given MElement to a maximum of the given size. Smaller images will not be changed.", params={@Param(name="element", value="The given MElement"), @Param(name="width", value="The maximum width"), @Param(name="height", value="The maximum height")}, result="reduced all MImages from the given MElement to a maximum of the given size. Smaller images will not be changed", examples={@Example(expression="myMElement.reduceAllImages(200, 300)", result="all reduced MImages from the given MElement")})
    public MElement reduceAllImages(MElement element, Integer width, Integer height) {
        MElement res;
        if (element instanceof MList) {
            ArrayList<MElement> newElements = new ArrayList<MElement>();
            for (MElement e : (MList)element) {
                newElements.add(this.reduceAllImages(e, width, height));
            }
            ((MList)element).clear();
            ((MList)element).addAll(newElements);
            res = element;
        } else if (element instanceof MParagraph) {
            MElement newContent = this.reduceAllImages(((MParagraph)element).getContents(), width, height);
            if (newContent != ((MParagraph)element).getContents()) {
                ((MParagraph)element).setContents(newContent);
            }
            res = element;
        } else if (element instanceof MTable) {
            for (MTable.MRow row : ((MTable)element).getRows()) {
                for (MTable.MCell cell : row.getCells()) {
                    MElement newContent = this.reduceAllImages(cell.getContents(), width, height);
                    if (newContent == cell.getContents()) continue;
                    cell.setContents(newContent);
                }
            }
            res = element;
        } else if (element instanceof MImage) {
            MImage image = (MImage)element;
            if (image.getWidth() > width) {
                image.setWidth(width.intValue());
                if (!image.conserveRatio() || image.getHeight() > height) {
                    image.setHeight(height.intValue());
                }
            } else if (image.getHeight() > height) {
                image.setHeight(height.intValue());
                if (!image.conserveRatio()) {
                    image.setWidth(width.intValue());
                }
            }
            res = image;
        } else {
            res = element;
        }
        return res;
    }

    @Documentation(value="Return the list of extension of the given type for the given extensible element.", params={@Param(name="element", value="The given extensible element"), @Param(name="eCls", value="the extension EClass")}, result="the list of extension of the given type for the given extensible element", examples={@Example(expression="myExtensibleElement.getExtensions(some::Extension)", result="the list of extension of the given type for the given extensible element")})
    public List<EObject> getExtensions(ExtensibleElement element, EClass eCls) {
        HashSet<EClass> eClasses = new HashSet<EClass>();
        eClasses.add(eCls);
        return this.getExtensions(element, eClasses);
    }

    @Documentation(value="Return the list of extension of the given types for the given extensible element.", params={@Param(name="element", value="The given extensible element"), @Param(name="eClasses", value="the extension EClasses")}, result="the list of extension of the given types for the given extensible element", examples={@Example(expression="myExtensibleElement.getExtensions({some::Extension1 | some::Extension2})", result="the list of extension of the given types for the given extensible element")})
    public List<EObject> getExtensions(ExtensibleElement element, Set<EClass> eClasses) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        block0: for (ElementExtension extension : element.getOwnedExtensions()) {
            for (EClass eCls : eClasses) {
                if (!eCls.isInstance((Object)extension)) continue;
                res.add((EObject)extension);
                continue block0;
            }
        }
        return res;
    }

    @Documentation(value="Tell if the given DRepresentation is visible in documentation.", params={@Param(name="rep", value="The given DRepresentation")}, result="true if the given DRepresentation is visible in documentation, false otherwise", examples={@Example(expression="myDRepresentation.isVisibleInDoc({some::Extension1 | some::Extension2})", result="true if the given DRepresentation is visible in documentation, false otherwise")})
    public boolean isVisibleInDoc(DRepresentation rep) {
        DRepresentationDescriptor descriptor = new DRepresentationQuery(rep).getRepresentationDescriptor();
        boolean res = descriptor != null ? RepresentationAnnotationHelper.isVisibleInDoc((DRepresentationDescriptor)descriptor) : true;
        return res;
    }

    @Documentation(value="Tell if the given DRepresentation is visible in LM.", params={@Param(name="rep", value="The given DRepresentation")}, result="true if the given DRepresentation is visible in LM, false otherwise", examples={@Example(expression="myDRepresentation.isVisibleInDoc({some::Extension1 | some::Extension2})", result="true if the given DRepresentation is visible in LM, false otherwise")})
    public boolean isVisibleInLM(DRepresentation rep) {
        DRepresentationDescriptor descriptor = new DRepresentationQuery(rep).getRepresentationDescriptor();
        boolean res = descriptor != null ? RepresentationAnnotationHelper.isVisibleInLM((DRepresentationDescriptor)descriptor) : true;
        return res;
    }

    @Documentation(value="Gets the list of available semantic browser query names for the given EObject.", params={@Param(name="eObj", value="The EObject")}, result="the list of available semantic browser queries for the given EObject", examples={@Example(expression="myCapellaElement.availableSBQueries()", result="Sequence{'query1', 'query2', ...}")})
    public List<String> availableSBQueries(EObject eObj) {
        ArrayList<String> res = new ArrayList<String>();
        Set queries = SemanticBrowserHelper.getCommonObjectCategories(Collections.singleton(eObj));
        for (ICategory query : queries) {
            res.add(query.getName());
        }
        Collections.sort(res);
        return res;
    }

    @Documentation(value="Gets the semantic browser query result for the given query name on the given EObject.", params={@Param(name="eObj", value="The EObject"), @Param(name="queryName", value="The semantic query name")}, result="the list of EObject", examples={@Example(expression="myCapellaElement.getSBQuery('query1')", result="Sequence{eObject1, eObject1, ...}")})
    public List<EObject> getSBQuery(EObject eObj, String queryName) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        Set queries = SemanticBrowserHelper.getCommonObjectCategories(Collections.singleton(eObj));
        ICategory foundQuery = null;
        for (ICategory query : queries) {
            if (!query.getName().equals(queryName)) continue;
            foundQuery = query;
            break;
        }
        if (foundQuery != null) {
            for (Object object : foundQuery.compute((Object)eObj)) {
                if (!(object instanceof EObject)) continue;
                res.add((EObject)object);
            }
        }
        return res;
    }

    protected IService getService(Method publicMethod) {
        Object result = "getExtensions".equals(publicMethod.getName()) ? new ExtensionsService(publicMethod, (Object)this) : new JavaMethodService(publicMethod, (Object)this);
        return result;
    }

    private static final class ExtensionsService
    extends FilterService {
        private ExtensionsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result;
            block6: {
                result = new LinkedHashSet<IType>();
                if (argTypes.size() != 2) break block6;
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        result.add((IType)new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    result.add(argTypes.get(1));
                } else {
                    Collection eObjectEClasses = queryEnvironment.getEPackageProvider().getTypes("ecore", "EObject");
                    for (EClassifier eObjectEClass : eObjectEClasses) {
                        result.add((IType)new EClassifierType(queryEnvironment, eObjectEClass));
                    }
                }
            }
            return result;
        }
    }
}

