/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.sirius.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Image;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MListImpl;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.obeonetwork.m2doc.ide.ui.element.impl.MImageSWTImpl;

public final class DTable2MTableConverter {
    public static final MStyle HEADER_STYLE = new MStyleImpl(null, 12, Color.BLACK, null, 1);
    public static final Color HEADER_BACKGROUND_COLOR = Color.GRAY;
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    public DTable2MTableConverter(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        this.adapterFactoryLabelProvider = adapterFactoryLabelProvider;
    }

    public MTable convertTable(DTable table, boolean withHeader) {
        MTableImpl mTable = new MTableImpl();
        mTable.setLabel(table.getName());
        MTableImpl.MRowImpl mHeaderRow = new MTableImpl.MRowImpl();
        mTable.getRows().add(mHeaderRow);
        mHeaderRow.getCells().add(new MTableImpl.MCellImpl(null, null));
        HashMap<Integer, DTableElementStyle> columnStyles = new HashMap<Integer, DTableElementStyle>();
        int colIdx = 0;
        for (DColumn column : table.getColumns()) {
            MTextImpl mText = new MTextImpl(column.getLabel(), DTable2MTableConverter.getHeaderStyle(withHeader));
            MTableImpl.MCellImpl mCell = new MTableImpl.MCellImpl((MElement)mText, DTable2MTableConverter.getHeaderBackgroundColor(withHeader));
            mHeaderRow.getCells().add(mCell);
            columnStyles.put(colIdx, column.getCurrentStyle());
            ++colIdx;
        }
        for (DLine line : table.getLines()) {
            List<MTable.MRow> mRows = this.convertRow(table, columnStyles, line, 0, withHeader);
            mTable.getRows().addAll(mRows);
        }
        return mTable;
    }

    private List<MTable.MRow> convertRow(DTable table, Map<Integer, DTableElementStyle> columnStyles, DLine line, int depth, boolean withHeader) {
        ArrayList<MTable.MRow> res = new ArrayList<MTable.MRow>();
        if (line.isVisible()) {
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            res.add((MTable.MRow)row);
            MListImpl headerCellContent = new MListImpl();
            if (depth > 0) {
                MTextImpl intentation = new MTextImpl(this.getIntentation(depth), DTable2MTableConverter.getHeaderStyle(withHeader));
                headerCellContent.add((Object)intentation);
            }
            Image image = this.adapterFactoryLabelProvider.getImage((Object)line.getTarget());
            MImageSWTImpl mImage = new MImageSWTImpl(image.getImageData());
            headerCellContent.add((Object)mImage);
            MTextImpl mHeaderText = new MTextImpl(line.getLabel(), DTable2MTableConverter.getHeaderStyle(withHeader));
            headerCellContent.add((Object)mHeaderText);
            MTableImpl.MCellImpl mHeaderColumnCell = new MTableImpl.MCellImpl((MElement)headerCellContent, DTable2MTableConverter.getHeaderBackgroundColor(withHeader));
            row.getCells().add(mHeaderColumnCell);
            DTableElementStyle rowStyle = line.getCurrentStyle();
            int colIdx = 0;
            while (colIdx < table.getColumns().size()) {
                DTableElementStyle style = rowStyle != null ? rowStyle : columnStyles.get(colIdx);
                if (style != null) {
                    row.getCells().add(new MTableImpl.MCellImpl(null, this.convertColor(style.getBackgroundColor())));
                } else {
                    row.getCells().add(new MTableImpl.MCellImpl(null, null));
                }
                ++colIdx;
            }
            for (DCell dcell : line.getCells()) {
                this.setCellContent(table, columnStyles, (MTable.MRow)row, rowStyle, dcell);
            }
            for (DLine child : line.getLines()) {
                res.addAll(this.convertRow(table, columnStyles, child, depth + 1, withHeader));
            }
        }
        return res;
    }

    private String getIntentation(int depth) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < depth) {
            res.append("  ");
            ++i;
        }
        return res.toString();
    }

    private void setCellContent(DTable table, Map<Integer, DTableElementStyle> columnStyles, MTable.MRow row, DTableElementStyle rowStyle, DCell dcell) {
        int colIdx = table.getColumns().indexOf((Object)dcell.getColumn());
        Object style = dcell.getCurrentStyle() != null ? dcell.getCurrentStyle() : (rowStyle != null ? rowStyle : columnStyles.get(colIdx));
        MTable.MCell mCell = (MTable.MCell)row.getCells().get(colIdx + 1);
        if (style != null) {
            MTextImpl mText = new MTextImpl(dcell.getLabel(), this.convertStyle((DTableElementStyle)style));
            mCell.setContents((MElement)mText);
            mCell.setBackgroundColor(this.convertColor(style.getBackgroundColor()));
        } else {
            MTextImpl mText = new MTextImpl(dcell.getLabel(), null);
            mCell.setContents((MElement)mText);
        }
    }

    public MStyle convertStyle(DTableElementStyle dStyle) {
        MStyleImpl mStyle = null;
        if (dStyle != null) {
            mStyle = new MStyleImpl(null, dStyle.getLabelSize(), this.convertColor(dStyle.getForegroundColor()), this.convertColor(dStyle.getBackgroundColor()), this.convertFontFormat((EList<FontFormat>)dStyle.getLabelFormat()));
        }
        return mStyle;
    }

    private int convertFontFormat(EList<FontFormat> fontFormats) {
        int result = 0;
        for (FontFormat format : fontFormats) {
            switch (format) {
                case BOLD_LITERAL: {
                    result |= 1;
                    break;
                }
                case ITALIC_LITERAL: {
                    result |= 2;
                    break;
                }
                case STRIKE_THROUGH_LITERAL: {
                    result |= 8;
                    break;
                }
                case UNDERLINE_LITERAL: {
                    result |= 4;
                }
            }
        }
        return result;
    }

    public Color convertColor(RGBValues rgb) {
        if (rgb != null) {
            return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        }
        return null;
    }

    private static MStyle getHeaderStyle(boolean withHeader) {
        Object res = withHeader ? HEADER_STYLE : null;
        return res;
    }

    private static Color getHeaderBackgroundColor(boolean withHeader) {
        Color res = withHeader ? HEADER_BACKGROUND_COLOR : null;
        return res;
    }
}

