/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.html.services.M2DocHTMLParser;

@ServiceProvider(value="Services available for HTML insertion.")
public class M2DocHTMLServices {
    private final URIConverter uriConverter;
    private final URI templateURI;
    private M2DocHTMLParser parser;

    public M2DocHTMLServices(URIConverter uriConverter, URI templateURI) {
        this.uriConverter = uriConverter;
        this.templateURI = templateURI;
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given HTML String.", params={@Param(name="htmlString", value="The HTML document.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'<html><head><title>Sample HTML for test purpose</title></head><body><h2 id=\"starting-with-m2doc\">Starting with M2Doc</h2></body></html>').fromHTMLString()", result="The Sequence of MElement corresponding to the given HTML String.")})
    public List<MElement> fromHTMLString(String htmlString) {
        return this.parser.parse(this.templateURI, htmlString);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given body String.", params={@Param(name="bodyString", value="The body String.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'<h2 id=\"starting-with-m2doc\">Starting with M2Doc</h2>'.fromHTMLBodyString()", result="The Sequence of MElement corresponding to the given HTML String.")})
    public List<MElement> fromHTMLBodyString(String bodyString) {
        return this.parser.parse(this.templateURI, "<html><head/><body>" + bodyString + "</body></html>");
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given HTML String.", params={@Param(name="htmlString", value="The HTML document."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given HTML String.", examples={@Example(expression="'<html><head><title>Sample HTML for test purpose</title></head><body><h2 id=\\\"starting-with-m2doc\\\">Starting with M2Doc</h2></body></html>'.fromHTMLString('http://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given HTML String.")})
    public List<MElement> fromHTMLString(String htmlString, String baseURI) {
        return this.parser.parse(URI.createURI((String)baseURI, (boolean)false), htmlString);
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given body String.", params={@Param(name="bodyString", value="The HTML body."), @Param(name="baseURI", value="The base URI to use for link and images resolving.")}, result="The Sequence of MElement corresponding to the given body String.", examples={@Example(expression="'<h2 id=\"starting-with-m2doc\">Starting with M2Doc</h2>'.fromHTMLBodyString('http://www.m2doc.org/')", result="The Sequence of MElement corresponding to the given body String.")})
    public List<MElement> fromHTMLBodyString(String bodyString, String baseURI) {
        return this.parser.parse(URI.createURI((String)baseURI, (boolean)false), "<html><head/><body>" + bodyString + "</body></html>");
    }

    @Documentation(value="Returns a Sequence of MElement corresponding to the given web page.", params={@Param(name="uriStr", value="The URI.")}, result="The Sequence of MElement corresponding to the given web page.", examples={@Example(expression="'http://www.m2doc.org/'.fromHTMLURI()", result="The Sequence of MElement corresponding to the given web page.")})
    public List<MElement> fromHTMLURI(String uriStr) throws IOException {
        URI htmlURI = URI.createURI((String)uriStr, (boolean)false);
        URI uri = htmlURI.resolve(this.templateURI);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream input = this.uriConverter.createInputStream(uri);){
            String htmlString = new String(IOUtils.toByteArray((InputStream)input));
            return this.parser.parse(uri, htmlString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setDestinationDocument(XWPFDocument destinationDocument) {
        this.parser = new M2DocHTMLParser(this.uriConverter, destinationDocument);
    }
}

