/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.capella.m2doc.commandline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.obeonetwork.capella.m2doc.commandline.M2DocCommandLinePlugin;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.launcher.internal.CLIUtils;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.ui.AbstractWorkbenchCommandLine;

public class M2DocCommandLine
extends AbstractWorkbenchCommandLine {
    private String[] genconfs = new String[1];

    public void printHelp() {
        System.out.println("Capella M2Doc Command Line");
        super.printHelp();
    }

    public void checkArgs(IApplicationContext context_p) throws CommandLineException {
        super.checkArgs(context_p);
    }

    public boolean execute(IApplicationContext context_p) {
        M2DocCommandLine.startFakeWorkbench();
        this.genconfs[0] = CommandLineArgumentHelper.getInstance().getFilePath();
        Collection<URI> genconfsURIs = this.validateArguments();
        boolean somethingWentWrong = false;
        System.out.println(CLIUtils.getDecorator().purple(" __          __  _                            _          __  __ ___     _            \n \\ \\        / / | |                          | |        |  \\/  |__ \\   | |           \n  \\ \\  /\\  / /__| | ___ ___  _ __ ___   ___  | |_ ___   | \\  / |  ) |__| | ___   ___ \n   \\ \\/  \\/ / _ \\ |/ __/ _ \\| '_ ` _ \\ / _ \\ | __/ _ \\  | |\\/| | / // _` |/ _ \\ / __|\n    \\  /\\  /  __/ | (_| (_) | | | | | |  __/ | || (_) | | |  | |/ /| (_| | (_) | (__ \n     \\/  \\/ \\___|_|\\___\\___/|_| |_| |_|\\___|  \\__\\___/  |_|  |_|____\\__,_|\\___/ \\___|"));
        System.out.println(CLIUtils.getDecorator().yellow("The command-line launcher to generate .docx from your models."));
        System.out.println("\u001b[0m");
        ArrayList<Generation> loadedGenConfs = new ArrayList<Generation>();
        ResourceSetImpl s = new ResourceSetImpl();
        for (URI uri : genconfsURIs) {
            if (s.getURIConverter().exists(uri, Collections.EMPTY_MAP)) {
                try {
                    Resource r = s.getResource(uri, true);
                    r.load(Collections.EMPTY_MAP);
                    for (EObject eObj : r.getContents()) {
                        if (!(eObj instanceof Generation)) continue;
                        loadedGenConfs.add((Generation)eObj);
                    }
                }
                catch (IOException e) {
                    somethingWentWrong = true;
                    M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error loading genconf: '" + uri.toString() + "' : " + e.getMessage(), (Throwable)e));
                }
                catch (RuntimeException e) {
                    somethingWentWrong = true;
                    M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error loading genconf: '" + uri.toString() + "' : " + e.getMessage(), (Throwable)e));
                }
                continue;
            }
            if (uri != null) {
                M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error loading genconf: '" + uri.toString() + "' : does not exist or is not accessible."));
                continue;
            }
            M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error loading genconf: uri is null."));
        }
        CLIUtils.ColoredPrinting monitor = new CLIUtils.ColoredPrinting(System.out);
        monitor.beginTask("Generating .docx documents", loadedGenConfs.size());
        for (Generation generation : loadedGenConfs) {
            try {
                System.out.println("Input: " + generation.eResource().getURI());
                List generated = GenconfUtils.generate((Generation)generation, (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)monitor);
                for (URI uri : generated) {
                    System.out.println("Output: " + uri.toString());
                }
                monitor.worked(1);
            }
            catch (DocumentGenerationException e) {
                M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error launching genconf: '" + generation.eResource().getURI().toString() + "' : " + e.getMessage(), (Throwable)e));
            }
            catch (IOException e) {
                M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error launching genconf: '" + generation.eResource().getURI().toString() + "' : " + e.getMessage(), (Throwable)e));
            }
            catch (DocumentParserException e) {
                M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error launching genconf: '" + generation.eResource().getURI().toString() + "' : " + e.getMessage(), (Throwable)e));
            }
        }
        monitor.beginTask("Saving workspace...", 1);
        try {
            ResourcesPlugin.getWorkspace().save(true, BasicMonitor.toIProgressMonitor((Monitor)monitor));
        }
        catch (CoreException e) {
            M2DocCommandLinePlugin.getPlugin().log(new Status(4, "org.obeonetwork.capella.m2doc.commandline", "Error while saving workspace: '" + e.getMessage(), (Throwable)e));
        }
        monitor.worked(1);
        return !somethingWentWrong;
    }

    public void prepare(IApplicationContext context_p) throws CommandLineException {
        super.prepare(context_p);
    }

    public static void startFakeWorkbench() {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public boolean openWindows() {
                return false;
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        });
    }

    private Collection<URI> validateArguments() {
        ArrayList<URI> result = new ArrayList<URI>();
        if (this.genconfs != null) {
            int cfr_ignored_0 = this.genconfs.length;
        }
        String[] stringArray = this.genconfs;
        int n = this.genconfs.length;
        int n2 = 0;
        while (n2 < n) {
            String modelPath = stringArray[n2];
            URI rawURI = null;
            try {
                rawURI = URI.createURI((String)modelPath, (boolean)true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (rawURI != null && !rawURI.hasAbsolutePath()) {
                rawURI = URI.createFileURI((String)modelPath);
            }
            result.add(rawURI);
            ++n2;
        }
        return result;
    }

    protected IStatus executeWithinWorkbench() {
        return Status.OK_STATUS;
    }
}

