/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element.impl;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;

public class AbosluteResizedImage
implements MImage {
    private int width;
    private int height;
    private int relativeWidth = -1;
    private int relativeHeight = -1;
    private boolean conserveRatio;
    private final MImage original;

    public AbosluteResizedImage(MImage original) {
        this.original = original;
        this.width = original.getWidth();
        this.height = original.getHeight();
        this.conserveRatio = original.conserveRatio();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        if (this.conserveRatio) {
            this.height = (int)(1.0 / this.getRatio() * (double)width);
        }
    }

    @Override
    public int getRelativeWidth() {
        return this.relativeWidth;
    }

    @Override
    public void setRelativeWidth(int relativeWidth) {
        throw new UnsupportedOperationException("Absolute size only.");
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        if (this.conserveRatio) {
            this.width = (int)(this.getRatio() * (double)height);
        }
    }

    @Override
    public int getRelativeHeight() {
        return this.relativeHeight;
    }

    @Override
    public void setRelativeHeight(int relativeHeight) {
        throw new UnsupportedOperationException("Absolute size only.");
    }

    @Override
    public boolean conserveRatio() {
        return this.conserveRatio;
    }

    @Override
    public void setConserveRatio(boolean conserveRatio) {
        this.conserveRatio = conserveRatio;
    }

    @Override
    public double getRatio() {
        return this.original.getRatio();
    }

    @Override
    public URI getURI() {
        return this.original.getURI();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.original.getInputStream();
    }

    @Override
    public PictureType getType() {
        return this.original.getType();
    }
}

