/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element.impl;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.ext.awt.image.codec.png.PNGTranscoderInternalCodecWriteAdapter;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;

public class MImageImpl
implements MImage {
    private final URI uri;
    private int width;
    private int height;
    private int relativeWidth = -1;
    private int relativeHeight = -1;
    private boolean conserveRatio;
    private double ratio;
    private final PictureType type;
    private final URIConverter uriConverter;
    private final byte[] buffer;

    public MImageImpl(URIConverter uriConverter, URI uri) {
        this(uriConverter, uri, PictureType.toType(uri));
    }

    public MImageImpl(byte[] buffer, PictureType type) {
        this(buffer, null, URI.createURI((String)("memory_buffer." + type.name().toLowerCase())), type);
    }

    public MImageImpl(URIConverter uriConverter, URI uri, PictureType type) {
        this(null, uriConverter, uri, type);
    }

    public MImageImpl(byte[] buffer, URIConverter uriConverter, URI uri, PictureType type) {
        this.buffer = buffer;
        this.uriConverter = uriConverter;
        this.uri = uri;
        this.type = type;
        if (type == PictureType.EMF) {
            try {
                Throwable throwable = null;
                Object var6_11 = null;
                try (InputStream is = this.getInputStream();){
                    HemfPicture emfPicture = new HemfPicture(is);
                    Rectangle2D bounds = emfPicture.getBounds();
                    this.width = (int)bounds.getWidth();
                    this.width = (int)bounds.getWidth();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.ratio = -1.0;
            }
        } else {
            try {
                Throwable e = null;
                Object var6_13 = null;
                try (InputStream input = this.getInputStream();){
                    BufferedImage image = ImageIO.read(input);
                    if (image != null) {
                        this.width = image.getWidth();
                        this.height = image.getHeight();
                        this.conserveRatio = true;
                        this.ratio = (double)this.width / (double)this.height;
                    } else {
                        this.conserveRatio = false;
                        this.ratio = -1.0;
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                this.ratio = -1.0;
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        if (this.conserveRatio) {
            this.height = (int)(1.0 / this.getRatio() * (double)width);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        if (this.conserveRatio) {
            this.width = (int)(this.getRatio() * (double)height);
        }
    }

    @Override
    public int getRelativeWidth() {
        return this.relativeWidth;
    }

    @Override
    public void setRelativeWidth(int relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @Override
    public int getRelativeHeight() {
        return this.relativeHeight;
    }

    @Override
    public void setRelativeHeight(int relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @Override
    public boolean conserveRatio() {
        return this.conserveRatio;
    }

    @Override
    public void setConserveRatio(boolean conserveRatio) {
        if (conserveRatio && this.ratio < 0.0) {
            throw new IllegalStateException("Can't conserve ratio: unknown ratio");
        }
        this.conserveRatio = conserveRatio;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getInputStream() throws IOException {
        if (this.getType() != PictureType.SVG) return this.createInputStream();
        M2DocPNGTranscoder transcoder = new M2DocPNGTranscoder();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                InputStream res;
                InputStream is = this.createInputStream();
                try {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        TranscoderInput input = new TranscoderInput(is);
                        TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                        transcoder.transcode(input, output);
                        res = new ByteArrayInputStream(os.toByteArray());
                    }
                    if (is == null) return res;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return res;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (TranscoderException e) {
            e.printStackTrace();
            throw new IOException("SVG to PNG transcode issue", e);
        }
    }

    protected InputStream createInputStream() throws IOException {
        InputStream res = this.buffer != null ? new ByteArrayInputStream(this.buffer) : this.uriConverter.createInputStream(this.uri);
        return res;
    }

    @Override
    public PictureType getType() {
        return this.type;
    }

    public String toString() {
        return "Image " + this.uri.toString();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    private final class M2DocPNGTranscoder
    extends PNGTranscoder {
        private M2DocPNGTranscoder() {
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            OutputStream ostream = output.getOutputStream();
            if (ostream == null) {
                throw new TranscoderException(Messages.formatMessage((String)"png.badoutput", null));
            }
            boolean forceTransparentWhite = false;
            if (this.hints.containsKey((Object)PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
                forceTransparentWhite = (Boolean)this.hints.get((Object)PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
            }
            if (forceTransparentWhite) {
                SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
                this.forceTransparentWhite(img, sppsm);
            }
            PNGTranscoderInternalCodecWriteAdapter adapter = new PNGTranscoderInternalCodecWriteAdapter();
            adapter.writeImage((PNGTranscoder)this, img, output);
        }
    }
}

