/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.util.HashMap;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.emf.common.util.EList;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHighlight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHighlightColor;

public class TemplateValidationGenerator
extends TemplateSwitch<Void> {
    private static final int ERROR_MESSAGE_FONT_SIZE = 16;

    @Override
    public Void caseDocumentTemplate(DocumentTemplate documentTemplate) {
        for (IConstruct template : documentTemplate.getHeaders()) {
            this.doSwitch(template);
        }
        this.doSwitch(documentTemplate.getBody());
        for (IConstruct template : documentTemplate.getFooters()) {
            this.doSwitch(template);
        }
        for (IConstruct template : documentTemplate.getTemplates()) {
            this.doSwitch(template);
        }
        return null;
    }

    @Override
    public Void caseTemplate(Template template) {
        this.insertErrorMessages(template);
        this.doSwitch(template.getBody());
        return null;
    }

    @Override
    public Void caseBlock(Block block) {
        this.insertErrorMessages(block);
        for (IConstruct construct : block.getStatements()) {
            this.doSwitch(construct);
        }
        return null;
    }

    @Override
    public Void caseConditional(Conditional conditional) {
        this.insertErrorMessages(conditional);
        this.doSwitch(conditional.getThen());
        if (conditional.getElse() != null) {
            this.doSwitch(conditional.getElse());
        }
        return null;
    }

    @Override
    public Void caseUserDoc(UserDoc object) {
        this.insertErrorMessages(object);
        this.doSwitch(object.getBody());
        return null;
    }

    @Override
    public Void caseRepetition(Repetition repetition) {
        this.insertErrorMessages(repetition);
        this.doSwitch(repetition.getBody());
        return null;
    }

    @Override
    public Void caseLet(Let let) {
        this.insertErrorMessages(let);
        this.doSwitch(let.getBody());
        return null;
    }

    @Override
    public Void caseQuery(Query query) {
        this.insertErrorMessages(query);
        return null;
    }

    @Override
    public Void caseComment(Comment comment) {
        this.insertErrorMessages(comment);
        return null;
    }

    @Override
    public Void caseTable(Table table) {
        this.insertErrorMessages(table);
        for (Row row : table.getRows()) {
            this.doSwitch(row);
        }
        return null;
    }

    @Override
    public Void caseRow(Row row) {
        for (Cell cell : row.getCells()) {
            this.doSwitch(cell);
        }
        return null;
    }

    @Override
    public Void caseCell(Cell cell) {
        this.doSwitch(cell.getBody());
        return null;
    }

    @Override
    public Void caseBookmark(Bookmark bookmark) {
        this.insertErrorMessages(bookmark);
        this.doSwitch(bookmark.getBody());
        return null;
    }

    @Override
    public Void caseLink(Link link) {
        this.insertErrorMessages(link);
        return null;
    }

    protected void insertErrorMessages(IConstruct abstractConstruct) {
        EList<TemplateValidationMessage> messages = abstractConstruct.getValidationMessages();
        HashMap<XWPFRun, Integer> offsets = new HashMap<XWPFRun, Integer>();
        for (TemplateValidationMessage message : messages) {
            offsets.put(message.getLocation(), 0);
        }
        for (TemplateValidationMessage message : messages) {
            int offset = (Integer)offsets.get(message.getLocation());
            int shift = this.addRunError(message, offset);
            offsets.put(message.getLocation(), offset + shift);
        }
    }

    private int addRunError(TemplateValidationMessage message, int offset) {
        int res = 0;
        if (message.getLocation().getParent() instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)message.getLocation().getParent();
            int basePosition = paragraph.getRuns().indexOf(message.getLocation()) + offset;
            String color = M2DocUtils.getColor(message.getLevel());
            XWPFRun newBlankRun = paragraph.insertNewRun(basePosition + ++res);
            newBlankRun.setText("    ");
            XWPFRun separationRun = paragraph.insertNewRun(basePosition + ++res);
            separationRun.setText("<---");
            separationRun.setColor(color);
            separationRun.setFontSize(16);
            CTHighlight separationHighlight = separationRun.getCTR().getRPr().addNewHighlight();
            separationHighlight.setVal(STHighlightColor.LIGHT_GRAY);
            XWPFRun messageRun = paragraph.insertNewRun(basePosition + ++res);
            messageRun.setText(message.getMessage());
            messageRun.setColor(color);
            messageRun.setFontSize(16);
            CTHighlight messageHighlight = messageRun.getCTR().getRPr().addNewHighlight();
            messageHighlight.setVal(STHighlightColor.LIGHT_GRAY);
        }
        return res;
    }
}

