---
layout: article
title: Capella M2Doc tutorial
subtitle: In-Flight Entertainment System (IFE) example
relativePath: ..
---

# Overview

M2Doc is a generic technology to generate MS Word(tm) documents.

Generation is driven by templates that navigate through a source model and transform model elements into a well formated document.

![Generated document.]({{page.relativePath}}/capella/images/m2doc-capella.png "Generated document.")

This tutorial explains how to install and launch two templates written for [Capella](https://mbse-capella.org/) models:

* [LA](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/LA-Complete/LA-Complete-template.docx): Logical specification of a system ([generated document](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/LA-Complete/LA-Complete-expected-generation.docx))
* [SA](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/SA-Complete/SA-Complete-template.docx): Whole specification of a system ([generated document](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/SA-Complete/SA-Complete-expected-generation.docx))

For this tutorial, we use In-Flight Entertainment System (IFE) as a sample model.

The way these documents are generated can be adapted by changing the templates. New documents can also be generated by creating brand new [templates](index.html#templates).

Browse [M2Doc](https://www.m2doc.org/) website for a complete features overview or the [support](https://www.m2doc.org/support/) page to get help in creating M2Doc templates.

You can also replay this webinar which explains how to launch M2Doc from Capella:

<iframe height="350" width="600" src="https://www.youtube.com/embed/tnLDinb0jkg?start=970"></iframe>


Note: M2Doc 1.1.0 and above are compatible with [Team for Capella](https://www.obeosoft.com/en/capella-professional-offer). You can test the generation by sharing the IFE example project provided in the extensions. Then edit the .genconf file to reference the shared SystemEngineering model element. You might need to open the Capella session first by double clicking the .aird file.

# Installation

First you need to download [Capella](https://mbse-capella.org/). It can be downloaded from this [download page](https://mbse-capella.org/download.html).

Once your download is finished, extract the downloaded archive and run the eclipe executable in the eclipse sub folder. You are now ready for the last step of the installation. You will need to [add a new update site](https://help.eclipse.org/mars/index.jsp?topic=%2Forg.eclipse.platform.doc.user%2Ftasks%2Ftasks-127.htm):

## Installation for Capella 7.0.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.1_M2Doc4.0.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.1_M2Doc4.0.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 4.0.0)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.0_M2Doc3.3.4/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.0_M2Doc3.3.4/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.3.4)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.0_M2Doc3.3.3/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/7.0.0_M2Doc3.3.3/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.3.3)

## Installation for Capella 6.1.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.2/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.2/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.3.2)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.3.1)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.1.0_M2Doc3.3.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.3.0)

## Installation for Capella 6.0.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.0.0_M2Doc3.2.2/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/6.0.0_M2Doc3.2.2/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.2)

## Installation for Capella 5.2.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.2.0_M2Doc3.2.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.2.0_M2Doc3.2.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.1)

## Installation for Capella 5.1.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.1.0_M2Doc3.2.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.1.0_M2Doc3.2.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.1)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.1.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.1.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.0)

## Installation for Capella 5.0.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.0.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/5.0.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.1.1)

## Installation for Capella 1.4.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.2_M2Doc3.2.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.2_M2Doc3.2.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.0)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.2/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.2/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.1.0)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.1_M2Doc3.2.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.1_M2Doc3.2.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.2.0)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.1.0)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.4.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 3.0.0)

## Installation for Capella 1.3.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.3.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.3.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 2.0.3)
* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.3.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.3.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 2.0.2)

## Installation for Capella 1.2.x

* `https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.2.1/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.2.1/full/org.obeonetwork.capella.update.full.zip) (M2Doc 2.0.0)

## Installation for Capella 1.1.x

* `https://obeo-networkaggregation-releases.s3-website-eu-west-1.amazonaws.com/capella-extensions/1.1.0/full` [zip](https://s3-eu-west-1.amazonaws.com/obeo-networkaggregation-releases/capella-extensions/1.1.0/full/org.obeonetwork.capella.update.full.zip) (M2Doc 1.0.0)

The update site for version 4.x and above contains [M2Doc](https://m2Doc.org) and the [Capella](https://mbse-capella.org/) integration. Select the following feature:

![The feature to install.]({{page.relativePath}}/capella/images/Install_4.png "The feature to install.")

Note: if your are installing other Capella extensions such as capella-requirements-vp or filtering using dropins, you shall not select the jsoup feature.

The update site for version 3.x and below contains [M2Doc](https://m2Doc.org) and the [Capella](https://mbse-capella.org/) integration. Select the following feature:

![The feature to install.]({{page.relativePath}}/capella/images/Install_3.png "The feature to install.")

Note: if your are installing other Capella extensions such as capella-requirements-vp or filtering using dropins, you shall not select the jsoup feature.

# Deploying the In-Flight Entertainment System (IFE) example

After restarting Capella, you can deploye the In-Flight Entertainment System (IFE) example in your workspace with the following steps:

Use the New > Other menu.

![The new menu.]({{page.relativePath}}/capella/images/New%20Menu.png "The new menu.")

The select the Capella - M2Doc > Capella IFE example with M2Doc templates project.

![The new project wizard page 1.]({{page.relativePath}}/capella/images/New%20Wizard%20Page%201.png "The new project wizard page 1.")

Click the next button.

![The new project wizard page 2.]({{page.relativePath}}/capella/images/New%20Wizard%20Page%202.png "The new project wizard page 2.")

Click the finish button and you should see the following project in your workspace.

![The IFE project content.]({{page.relativePath}}/capella/images/IFE%20Project.png "The IFE project content.")

# Creating a generation configuration

After experimenting with the provided [IFE example](index.html#deploying-the-in-flight-entertainment-system-ife-example) you can create your own templates for you project. One way can be to start from the provided template an edit them. You can check the main documentation on [template authoring]({{page.relativePath}}/ref-doc/nightly/index.html#template-authoring).

Once you have your template you will need to initialize the document genereation. You can check the [Initializing a generation configuration]({{page.relativePath}}/ref-doc/nightly/index.html#initializing-a-generation-configuration).

You need to make sure the SiriusSession option is defined and is referencing your .aird file. This is needed to use [Sirius services]({{page.relativePath}}/ref-doc/nightly/index.html#services) like exporting diagrams as images:

![SiriusSession Option.]({{page.relativePath}}/capella/images/SiriusSession%20Option.png "SiriusSession Option.")

Setting this option should allow you to select model elements for each model variable you have in your template. By default the first element matching the declared type of the variable will be selected, but you can edit the value by selecting the variable and using the edit button:

![Edit Variable.]({{page.relativePath}}/capella/images/Edit%20Variable.png "Edit Variable.")

You will see your Capella model to select the value from:

![Select Variable Value.]({{page.relativePath}}/capella/images/Select%20Variable%20Value.png "Select Variable Value.")

The validation button will only be enable if the selected value is compatible with the variable declared type.

# Team for Capella

You can also use M2Doc with [Team for Capella](https://www.obeosoft.com/en/capella-professional-offer). The easiest way to get started with your shared project, is to create a new .genconf file in that project that will reference your template. If you had existing .genconf files before you shared your project to Team for Capella, they will still reference the local Capella model. You can also edit them to reference the shared project's .aird file.

To use the shared project make sure the SiriusSession option reference the shared .aird file that has been renamed. You should need to add "team" like this:

* In-Flight Entertainment System.aird

becomes:

* In-Flight Entertainment System.team.aird

Secondly you will need to set the value of your model variables since the model has been moved to the Team for Capella server. By default the first element matching the declared type of the variable will be selected, but you can edit the value by selecting the variable and using the edit button:

![Edit Variable.]({{page.relativePath}}/capella/images/Edit%20Variable.png "Edit Variable.")

You will see your Capella model to select the value from:

![Select Variable Value.]({{page.relativePath}}/capella/images/Select%20Variable%20Value.png "Select Variable Value.")

If you want to make sure you are referencing the shared model, you can open the .genconf file in a text editor and make sure the model reference starts with "cdo://".

# Templates

You can run templates by using the corresponding .genconf file at the root of the project, to do so use the .genconf file as shown [here]({{page.relativePath}}/ref-doc/nightly/index.html#launching-a-generation). Templates are located in the template sub folder of the project.

If you want to go further in template editing you should have a look at the [M2Doc documentation]({{page.relativePath}}/ref-doc/nightly/index.html).

In the following section you will find a description of each templates.

## LA Complete

This template allows the generation of a logical specification of the content of the system. It starts by a description of the hierarchy of logical components, with, for each, its allocated functions and provided/required interfaces. Then the function decomposition is presented including functional exchanges. At the end, a reference of data structures is generated. You can have a look at the [LA template](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/LA-Complete/LA-Complete-template.docx) and the generated [LA document](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/LA-Complete/LA-Complete-expected-generation.docx).

## SA Complete

This template allows the generation of a document concerning the whole specification of a system. Starting from mission and capabilities of the system, the template presents the context of the system, its state machines and communicating actors, and functional specifications. At the end a reference of data structures is generated.You can have a look at the [SA template](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/SA-Complete/SA-Complete-template.docx) and the generated [SA document](https://github.com/ObeoNetwork/Capella-Extensions/raw/master/tests/org.obeonetwork.capella.m2doc.aql.queries.tests/resources/IFE/SA-Complete/SA-Complete-expected-generation.docx).

