/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Colors;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;

public class HighlightCategoryColorSource
extends StandardCategoryColorSource {
    private int highlightRowIndex;
    private int highlightColumnIndex;
    private Color highlightColor;

    public HighlightCategoryColorSource() {
        this(-1, -1, Color.RED, Colors.getDefaultColors());
    }

    public HighlightCategoryColorSource(int row, int column, Color highlightColor, Color ... colors) {
        super(colors);
        this.highlightRowIndex = row;
        this.highlightColumnIndex = column;
        this.highlightColor = highlightColor;
    }

    public int getHighlightRowIndex() {
        return this.highlightRowIndex;
    }

    public void setHighlightRowIndex(int index) {
        this.highlightRowIndex = index;
    }

    public int getHighlightColumnIndex() {
        return this.highlightColumnIndex;
    }

    public void setHighlightColumnIndex(int index) {
        this.highlightColumnIndex = index;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.highlightColor = color;
    }

    @Override
    public Color getColor(int series, int row, int column) {
        Color result = super.getColor(series, row, column);
        if (row == this.highlightRowIndex && column == this.highlightColumnIndex) {
            result = this.highlightColor;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightCategoryColorSource)) {
            return false;
        }
        HighlightCategoryColorSource that = (HighlightCategoryColorSource)obj;
        if (this.highlightColumnIndex != that.highlightColumnIndex) {
            return false;
        }
        if (this.highlightRowIndex != that.highlightRowIndex) {
            return false;
        }
        if (!this.highlightColor.equals(that.highlightColor)) {
            return false;
        }
        return super.equals(obj);
    }
}

