/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Colors;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import com.orsoncharts.style.StandardChartStyle;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.Orientation;
import java.io.IOException;
import java.io.InputStreamReader;

public class ScatterPlot3D3 {
    public static XYZDataset[] createDatasets() {
        XYZDataset[] datasets = new XYZDataset[]{ScatterPlot3D3.createDataset("sepal length", "sepal width", "petal length"), ScatterPlot3D3.createDataset("sepal length", "sepal width", "petal width"), ScatterPlot3D3.createDataset("sepal length", "petal width", "petal length"), ScatterPlot3D3.createDataset("sepal width", "petal width", "petal length")};
        return datasets;
    }

    public static Chart3D createChart(String title, XYZDataset dataset, String xLabel, String yLabel, String zLabel) {
        Chart3D chart = Chart3DFactory.createScatterChart(null, null, dataset, xLabel, yLabel, zLabel);
        TextElement title1 = new TextElement(title);
        title1.setFont(StandardChartStyle.createDefaultFont(0, 16));
        chart.setTitle(title1);
        chart.setLegendAnchor(LegendAnchor.BOTTOM_LEFT);
        chart.setLegendOrientation(Orientation.VERTICAL);
        XYZPlot plot = (XYZPlot)chart.getPlot();
        ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
        renderer.setSize(0.15);
        renderer.setColors(Colors.createIntenseColors());
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        return chart;
    }

    private static XYZDataset createDataset(Comparable<?> xKey, Comparable<?> yKey, Comparable<?> zKey) {
        KeyedValues3D<? extends Number> data;
        InputStreamReader in = new InputStreamReader(ScatterPlot3D3.class.getResourceAsStream("iris.txt"));
        try {
            data = JSONUtils.readKeyedValues3D(in);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return DataUtils.extractXYZDatasetFromColumns(data, xKey, yKey, zKey);
    }
}

