/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo2
extends JFrame {
    public AxisRangeDemo2(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(AxisRangeDemo2.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel content = new CustomDemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        CategoryDataset3D dataset = AxisRangeDemo2.createDataset();
        Chart3D chart = Chart3DFactory.createBarChart("AxisRangeDemo2", "Chart created with Orson Charts", dataset, "Row", "Category", "Value");
        chart.setChartBoxColor(new Color(255, 255, 255, 128));
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
        plot.getValueAxis().setRange(-500.0, 500.0);
        plot.getRowAxis().setVisible(false);
        BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
        renderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator("%4$.2f"));
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        content.add(new DisplayPanel3D(chartPanel));
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        return content;
    }

    private static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D dataset = new StandardCategoryDataset3D();
        DefaultKeyedValues<Integer> s0 = new DefaultKeyedValues<Integer>();
        s0.put((Comparable<?>)((Object)"A"), -500);
        s0.put((Comparable<?>)((Object)"B"), -200);
        s0.put((Comparable<?>)((Object)"C"), -400);
        s0.put((Comparable<?>)((Object)"D"), -150);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"All Negative"), (KeyedValues<? extends Number>)s0);
        DefaultKeyedValues<Integer> s1 = new DefaultKeyedValues<Integer>();
        s1.put((Comparable<?>)((Object)"A"), -500);
        s1.put((Comparable<?>)((Object)"B"), 500);
        s1.put((Comparable<?>)((Object)"C"), 0);
        s1.put((Comparable<?>)((Object)"D"), -150);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Alternating 1"), (KeyedValues<? extends Number>)s1);
        DefaultKeyedValues<Integer> s2 = new DefaultKeyedValues<Integer>();
        s2.put((Comparable<?>)((Object)"A"), 500);
        s2.put((Comparable<?>)((Object)"B"), -500);
        s2.put((Comparable<?>)((Object)"C"), 0);
        s2.put((Comparable<?>)((Object)"D"), 150);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Alternating 2"), (KeyedValues<? extends Number>)s2);
        DefaultKeyedValues<Integer> s3 = new DefaultKeyedValues<Integer>();
        s3.put((Comparable<?>)((Object)"A"), 500);
        s3.put((Comparable<?>)((Object)"B"), 200);
        s3.put((Comparable<?>)((Object)"C"), 400);
        s3.put((Comparable<?>)((Object)"D"), 150);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"All Positive"), (KeyedValues<? extends Number>)s3);
        return dataset;
    }

    public static void main(String[] args) {
        AxisRangeDemo2 app = new AxisRangeDemo2("OrsonCharts: AxisRangeDemo2.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider slider1 = new JSlider(-1000, 0);
        private JSlider slider2;

        public CustomDemoPanel(LayoutManager layout) {
            super(layout);
            this.slider1.setValue(-500);
            this.slider2 = new JSlider(0, 1000);
            this.slider2.setValue(500);
            this.slider1.addChangeListener(this);
            this.slider2.addChangeListener(this);
            JPanel sliderPanel = new JPanel(new FlowLayout());
            sliderPanel.add(new JLabel("Lower bound: "));
            sliderPanel.add(this.slider1);
            sliderPanel.add(new JLabel("Upper bound: "));
            sliderPanel.add(this.slider2);
            this.add((Component)sliderPanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int max;
            Chart3D chart = (Chart3D)this.getChartPanel().getDrawable();
            CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
            ValueAxis3D yAxis = plot.getValueAxis();
            int min = this.slider1.getValue();
            if (min != (max = this.slider2.getValue())) {
                yAxis.setRange(min, max);
            }
        }
    }
}

