/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.Range;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.plot.XYZPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo7
extends JFrame {
    public AxisRangeDemo7(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(AxisRangeDemo7.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        XYZDataset dataset = AxisRangeDemo7.createDataset();
        CustomDemoPanel content = new CustomDemoPanel((LayoutManager)new BorderLayout(), dataset);
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        Chart3D chart = Chart3DFactory.createXYZLineChart("AxisRangeDemo7", "Chart created with Orson Charts", dataset, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(10.0, 4.0, 10.0));
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    private static XYZDataset createDataset() {
        XYZSeriesCollection dataset = new XYZSeriesCollection();
        for (int s = 1; s <= 10; ++s) {
            XYZSeries s1 = AxisRangeDemo7.createRandomSeries("S" + s, s, 100);
            dataset.add(s1);
        }
        return dataset;
    }

    private static XYZSeries createRandomSeries(String name, int series, int count) {
        XYZSeries s = new XYZSeries((Comparable<?>)((Object)name));
        double y = 10.0;
        for (int i = 0; i < count; ++i) {
            s.add(i, y += (Math.random() - 0.48) * 2.0, series * 30);
        }
        return s;
    }

    public static void main(String[] args) {
        AxisRangeDemo7 app = new AxisRangeDemo7("OrsonCharts : AxisRangeDemo7.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider xslider1;
        private JSlider xslider2;
        private JSlider yslider1;
        private JSlider yslider2;
        private JSlider zslider1;
        private JSlider zslider2;

        public CustomDemoPanel(LayoutManager layout, XYZDataset dataset) {
            super(layout);
            Range xRange = DataUtils.findXRange(dataset);
            Range yRange = DataUtils.findYRange(dataset);
            Range zRange = DataUtils.findZRange(dataset);
            int xstart = (int)Math.floor(xRange.getMin());
            int ystart = (int)Math.floor(yRange.getMin());
            int zstart = (int)Math.floor(zRange.getMin());
            int xend = (int)Math.ceil(xRange.getMax());
            int yend = (int)Math.ceil(yRange.getMax());
            int zend = (int)Math.ceil(zRange.getMax());
            int xmid = (xstart + xend) / 2;
            int ymid = (ystart + yend) / 2;
            int zmid = (zstart + zend) / 2;
            this.xslider1 = new JSlider(xstart, xmid);
            this.xslider1.setValue(xstart);
            this.xslider2 = new JSlider(xmid, xend);
            this.xslider2.setValue(xend);
            this.xslider1.addChangeListener(this);
            this.xslider2.addChangeListener(this);
            this.yslider1 = new JSlider(ystart, ymid);
            this.yslider1.setValue(ystart);
            this.yslider2 = new JSlider(ymid, yend);
            this.yslider2.setValue(yend);
            this.yslider1.addChangeListener(this);
            this.yslider2.addChangeListener(this);
            this.zslider1 = new JSlider(zstart, zmid);
            this.zslider1.setValue(zstart);
            this.zslider2 = new JSlider(zmid, zend);
            this.zslider2.setValue(zend);
            this.zslider1.addChangeListener(this);
            this.zslider2.addChangeListener(this);
            JPanel rangePanel = new JPanel(new GridLayout(3, 1));
            JPanel xPanel = new JPanel(new FlowLayout());
            xPanel.add(new JLabel("X axis: "));
            xPanel.add(new JLabel("Lower bound: "));
            xPanel.add(this.xslider1);
            xPanel.add(new JLabel("Upper bound: "));
            xPanel.add(this.xslider2);
            rangePanel.add(xPanel);
            JPanel yPanel = new JPanel(new FlowLayout());
            yPanel.add(new JLabel("Y axis: "));
            yPanel.add(new JLabel("Lower bound: "));
            yPanel.add(this.yslider1);
            yPanel.add(new JLabel("Upper bound: "));
            yPanel.add(this.yslider2);
            rangePanel.add(yPanel);
            JPanel zPanel = new JPanel(new FlowLayout());
            zPanel.add(new JLabel("Z axis: "));
            zPanel.add(new JLabel("Lower bound: "));
            zPanel.add(this.zslider1);
            zPanel.add(new JLabel("Upper bound: "));
            zPanel.add(this.zslider2);
            rangePanel.add(zPanel);
            this.add((Component)rangePanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double zmax;
            double ymax;
            double xmax;
            Chart3D chart = (Chart3D)this.getChartPanel().getDrawable();
            XYZPlot plot = (XYZPlot)chart.getPlot();
            ValueAxis3D xAxis = plot.getXAxis();
            double xmin = this.xslider1.getValue();
            if (xmin != (xmax = (double)this.xslider2.getValue())) {
                xAxis.setRange(xmin, xmax);
            }
            ValueAxis3D yAxis = plot.getYAxis();
            double ymin = this.yslider1.getValue();
            if (ymin != (ymax = (double)this.yslider2.getValue())) {
                yAxis.setRange(ymin, ymax);
            }
            ValueAxis3D zAxis = plot.getZAxis();
            double zmin = this.zslider1.getValue();
            if (zmin != (zmax = (double)this.zslider2.getValue())) {
                zAxis.setRange(zmin, zmax);
            }
        }
    }
}

