/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.demo.DemoDescription;
import com.orsoncharts.demo.swing.AreaChart3DDemo1;
import com.orsoncharts.demo.swing.DemoDisplayer;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.style.ChartStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class OrsonChartsDemoComponent
extends JPanel
implements TreeSelectionListener {
    private static final String PREFIX = "com.orsoncharts.demo.swing.";
    private static final String ABOUT_PREFIX = "/com/orsoncharts/demo/";
    private TreePath defaultChartPath;
    private JPanel chartContainer;
    private JTextPane chartDescriptionPane;
    private ChartStyle style = null;

    public OrsonChartsDemoComponent() {
        super(new BorderLayout());
        this.add(this.createContent());
    }

    public ChartStyle getChartStyle() {
        if (this.style == null) {
            return null;
        }
        return this.style.clone();
    }

    public void setChartStyle(ChartStyle style) {
        this.style = style;
    }

    public JPanel getChartContainer() {
        return this.chartContainer;
    }

    public JTextPane getChartDescriptionPane() {
        return this.chartDescriptionPane;
    }

    private JComponent createContent() {
        JSplitPane content = new JSplitPane(1);
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JTree tree = new JTree(this.createTreeModel());
        tree.addTreeSelectionListener(this);
        tree.setSelectionPath(this.defaultChartPath);
        JScrollPane scroller = new JScrollPane(tree);
        scroller.setPreferredSize(new Dimension(300, 580));
        content.add(scroller);
        content.add(this.createChartComponent());
        return content;
    }

    private TreeModel createTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Orson Charts");
        root.add(this.createCategoryChartsNode(root));
        root.add(this.createPieChartsNode());
        root.add(this.createXYZChartsNode());
        root.add(this.createAxisRangeTestNode());
        return new DefaultTreeModel(root);
    }

    private MutableTreeNode createNode(String name, String file, String description) {
        return new DefaultMutableTreeNode(new DemoDescription(name, file, description));
    }

    private MutableTreeNode createCategoryChartsNode(DefaultMutableTreeNode r) {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode("Category Charts");
        MutableTreeNode defaultNode = this.createNode("com.orsoncharts.demo.swing.AreaChart3DDemo1", "AreaChart3DDemo1.java", "/com/orsoncharts/demo/AreaChart3D1.html");
        this.defaultChartPath = new TreePath(new Object[]{r, n, defaultNode});
        n.add(defaultNode);
        n.add(this.createNode("com.orsoncharts.demo.swing.AreaChart3DDemo2", "AreaChart3DDemo2.java", "/com/orsoncharts/demo/AreaChart3D2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.BarChart3DDemo1", "BarChart3DDemo1.java", "/com/orsoncharts/demo/BarChart3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.BarChart3DDemo2", "BarChart3DDemo2.java", "/com/orsoncharts/demo/BarChart3D2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.CategoryMarkerDemo1", "CategoryMarkerDemo1.java", "/com/orsoncharts/demo/CategoryMarkerDemo1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.LineChart3DDemo1", "LineChart3DDemo1.java", "/com/orsoncharts/demo/LineChart3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.LineChart3DDemo2", "LineChart3DDemo2.java", "/com/orsoncharts/demo/LineChart3D2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.StackedBarChart3DDemo1", "StackedBarChart3DDemo1.java", "/com/orsoncharts/demo/StackedBarChart3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.StackedBarChart3DDemo2", "StackedBarChart3DDemo2.java", "/com/orsoncharts/demo/StackedBarChart3D2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.StackedBarChart3DDemo3", "StackedBarChart3DDemo3.java", "/com/orsoncharts/demo/StackedBarChart3D3.html"));
        return n;
    }

    private MutableTreeNode createPieChartsNode() {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode("Pie Charts");
        n.add(this.createNode("com.orsoncharts.demo.swing.PieChart3DDemo1", "PieChart3DDemo1.java", "/com/orsoncharts/demo/PieChart3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.PieChart3DDemo2", "PieChart3DDemo2.java", "/com/orsoncharts/demo/PieChart3D2.html"));
        return n;
    }

    private MutableTreeNode createXYZChartsNode() {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode("XYZ Charts");
        n.add(this.createNode("com.orsoncharts.demo.swing.RangeMarkerDemo1", "RangeMarkerDemo1.java", "/com/orsoncharts/demo/RangeMarker1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.ScatterPlot3DDemo1", "ScatterPlot3DDemo1.java", "/com/orsoncharts/demo/ScatterPlot3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.ScatterPlot3DDemo2", "ScatterPlot3DDemo2.java", "/com/orsoncharts/demo/ScatterPlot3D2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.ScatterPlot3DDemo3", "ScatterPlot3DDemo3.java", "/com/orsoncharts/demo/ScatterPlot3D3.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.SurfaceRendererDemo1", "SurfaceRendererDemo1.java", "/com/orsoncharts/demo/SurfaceRenderer1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.SurfaceRendererDemo2", "SurfaceRendererDemo2.java", "/com/orsoncharts/demo/SurfaceRenderer2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.XYZBarChart3DDemo1", "XYZBarChart3DDemo1.java", "/com/orsoncharts/demo/XYZBarChart3D1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.XYZLineChart3DDemo1", "XYZLineChart3DDemo1.java", "/com/orsoncharts/demo/XYZLineChart3D1.html"));
        return n;
    }

    private MutableTreeNode createAxisRangeTestNode() {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode("Axis Range Tests");
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo1", "AxisRangeDemo1.java", "/com/orsoncharts/demo/AxisRangeDemo1.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo2", "AxisRangeDemo2.java", "/com/orsoncharts/demo/AxisRangeDemo2.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo3", "AxisRangeDemo3.java", "/com/orsoncharts/demo/AxisRangeDemo3.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo4", "AxisRangeDemo4.java", "/com/orsoncharts/demo/AxisRangeDemo4.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo5", "AxisRangeDemo5.java", "/com/orsoncharts/demo/AxisRangeDemo5.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo6", "AxisRangeDemo6.java", "/com/orsoncharts/demo/AxisRangeDemo6.html"));
        n.add(this.createNode("com.orsoncharts.demo.swing.AxisRangeDemo7", "AxisRangeDemo7.java", "/com/orsoncharts/demo/AxisRangeDemo7.html"));
        return n;
    }

    private JComponent createChartComponent() {
        JSplitPane splitter = new JSplitPane(0);
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.chartContainer = new JPanel(new BorderLayout());
        DemoPanel chartPanel = AreaChart3DDemo1.createDemoPanel();
        chartPanel.setBorder(b);
        this.chartContainer.add(chartPanel);
        splitter.add(this.chartContainer);
        JPanel lowerPanel = new JPanel(new BorderLayout());
        lowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.BLACK)));
        this.chartDescriptionPane = new JTextPane();
        this.chartDescriptionPane.setPreferredSize(new Dimension(400, 200));
        this.chartDescriptionPane.setEditable(false);
        this.chartDescriptionPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.chartDescriptionPane.setText("No chart description available.");
        lowerPanel.add(this.chartDescriptionPane);
        splitter.add(lowerPanel);
        return splitter;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        Object obj = path.getLastPathComponent();
        if (obj != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)obj;
            Object userObj = n.getUserObject();
            if (userObj instanceof DemoDescription) {
                DemoDescription dd = (DemoDescription)userObj;
                SwingUtilities.invokeLater(new DemoDisplayer(this, dd));
            } else {
                this.chartContainer.removeAll();
                this.chartContainer.add(this.createNoDemoSelectedPanel());
                this.chartContainer.validate();
                URL descriptionURL = OrsonChartsDemo.class.getResource("select.html");
                if (descriptionURL != null) {
                    try {
                        this.chartDescriptionPane.setPage(descriptionURL);
                    }
                    catch (IOException ex) {
                        System.err.println("Attempted to read a bad URL: " + descriptionURL);
                    }
                }
            }
        }
    }

    private JComponent createNoDemoSelectedPanel() {
        return new JButton("No demo selected.");
    }
}

