/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.Range;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.NullConversion;
import com.orsoncharts.data.Values;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.util.ArgChecks;
import java.util.List;

public class DataUtils {
    private DataUtils() {
    }

    public static double total(Values<Number> values) {
        double result = 0.0;
        for (int i = 0; i < values.getItemCount(); ++i) {
            Number n = values.getValue(i);
            if (n == null) continue;
            result += n.doubleValue();
        }
        return result;
    }

    public static int count(KeyedValues3D<?> data, Comparable<?> seriesKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        int count = 0;
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(seriesIndex, r, c);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static int countForRow(KeyedValues3D<?> data, Comparable<?> rowKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        int rowIndex = data.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        int count = 0;
        int seriesCount = data.getSeriesCount();
        int columnCount = data.getColumnCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(s, rowIndex, c);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static int countForColumn(KeyedValues3D<?> data, Comparable<?> columnKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        int columnIndex = data.getColumnIndex(columnKey);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column not found: " + columnKey);
        }
        int count = 0;
        int seriesCount = data.getSeriesCount();
        int rowCount = data.getRowCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int r = 0; r < rowCount; ++r) {
                Number n = (Number)data.getValue(s, r, columnIndex);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static double total(KeyedValues3D<? extends Number> data, Comparable<?> seriesKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(seriesIndex, r, c);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static double totalForRow(KeyedValues3D<? extends Number> data, Comparable<?> rowKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        int rowIndex = data.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        double total = 0.0;
        int seriesCount = data.getSeriesCount();
        int columnCount = data.getColumnCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(s, rowIndex, c);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static double totalForColumn(KeyedValues3D<? extends Number> data, Comparable<?> columnKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        int columnIndex = data.getColumnIndex(columnKey);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column not found: " + columnKey);
        }
        double total = 0.0;
        int seriesCount = data.getSeriesCount();
        int rowCount = data.getRowCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int r = 0; r < rowCount; ++r) {
                Number n = (Number)data.getValue(s, r, columnIndex);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findValueRange(data, Double.NaN);
    }

    public static Range findValueRange(Values3D<? extends Number> data, double base) {
        return DataUtils.findValueRange(data, base, true);
    }

    public static Range findValueRange(Values3D<? extends Number> data, double base, boolean finite) {
        ArgChecks.nullNotPermitted(data, "data");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int series = 0; series < data.getSeriesCount(); ++series) {
            for (int row = 0; row < data.getRowCount(); ++row) {
                for (int col = 0; col < data.getColumnCount(); ++col) {
                    double d = data.getDoubleValue(series, row, col);
                    if (Double.isNaN(d) || finite && Double.isInfinite(d)) continue;
                    min = Math.min(min, d);
                    max = Math.max(max, d);
                }
            }
        }
        if (!Double.isNaN(base)) {
            min = Math.min(min, base);
            max = Math.max(max, base);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findStackedValueRange(Values3D<? extends Number> data) {
        return DataUtils.findStackedValueRange(data, 0.0);
    }

    public static Range findStackedValueRange(Values3D<? extends Number> data, double base) {
        ArgChecks.nullNotPermitted(data, "data");
        double min = base;
        double max = base;
        int seriesCount = data.getSeriesCount();
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int col = 0; col < data.getColumnCount(); ++col) {
                double[] total = DataUtils.stackSubTotal(data, base, seriesCount, row, col);
                min = Math.min(min, total[0]);
                max = Math.max(max, total[1]);
            }
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static double[] stackSubTotal(Values3D<? extends Number> data, double base, int series, int row, int column) {
        double neg = base;
        double pos = base;
        for (int s = 0; s < series; ++s) {
            double v = data.getDoubleValue(s, row, column);
            if (v > 0.0) {
                pos += v;
                continue;
            }
            if (!(v < 0.0)) continue;
            neg += v;
        }
        return new double[]{neg, pos};
    }

    public static double total(XYZDataset data, Comparable<?> seriesKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        double total = 0.0;
        int itemCount = data.getItemCount(seriesIndex);
        for (int item = 0; item < itemCount; ++item) {
            double y = data.getY(seriesIndex, item);
            if (Double.isNaN(y)) continue;
            total += y;
        }
        return total;
    }

    public static Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset, Double.NaN);
    }

    public static Range findXRange(XYZDataset dataset, double inc) {
        return DataUtils.findXRange(dataset, inc, true);
    }

    public static Range findXRange(XYZDataset dataset, double inc, boolean finite) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double x = dataset.getX(s, i);
                if (Double.isNaN(x) || finite && Double.isInfinite(x)) continue;
                min = Math.min(x, min);
                max = Math.max(x, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset, Double.NaN);
    }

    public static Range findYRange(XYZDataset dataset, double inc) {
        return DataUtils.findYRange(dataset, inc, true);
    }

    public static Range findYRange(XYZDataset dataset, double inc, boolean finite) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double y = dataset.getY(s, i);
                if (Double.isNaN(y) || finite && Double.isInfinite(y)) continue;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset, Double.NaN);
    }

    public static Range findZRange(XYZDataset dataset, double inc) {
        return DataUtils.findZRange(dataset, inc, true);
    }

    public static Range findZRange(XYZDataset dataset, double inc, boolean finite) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArgChecks.finiteRequired(inc, "inc");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double z = dataset.getZ(s, i);
                if (Double.isNaN(z) || finite && Double.isInfinite(z)) continue;
                min = Math.min(z, min);
                max = Math.max(z, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static XYZDataset extractXYZDatasetFromRows(KeyedValues3D<? extends Number> source, Comparable<?> xRowKey, Comparable<?> yRowKey, Comparable<?> zRowKey) {
        return DataUtils.extractXYZDatasetFromColumns(source, xRowKey, yRowKey, zRowKey, NullConversion.SKIP, null);
    }

    public static XYZDataset extractXYZDatasetFromRows(KeyedValues3D<? extends Number> source, Comparable<?> xRowKey, Comparable<?> yRowKey, Comparable<?> zRowKey, NullConversion nullConversion, List<KeyedValues3DItemKey> exceptions) {
        ArgChecks.nullNotPermitted(source, "source");
        ArgChecks.nullNotPermitted(xRowKey, "xRowKey");
        ArgChecks.nullNotPermitted(yRowKey, "yRowKey");
        ArgChecks.nullNotPermitted(zRowKey, "zRowKey");
        XYZSeriesCollection dataset = new XYZSeriesCollection();
        for (Comparable<?> seriesKey : source.getSeriesKeys()) {
            XYZSeries series = new XYZSeries(seriesKey);
            for (Comparable<?> colKey : source.getColumnKeys()) {
                Comparable<?> rrKey;
                Number x = source.getValue(seriesKey, xRowKey, colKey);
                Number y = source.getValue(seriesKey, yRowKey, colKey);
                Number z = source.getValue(seriesKey, zRowKey, colKey);
                if (x != null && y != null && z != null) {
                    series.add(x.doubleValue(), y.doubleValue(), z.doubleValue());
                    continue;
                }
                if (exceptions != null) {
                    rrKey = zRowKey;
                    if (x == null) {
                        rrKey = xRowKey;
                    } else if (y == null) {
                        rrKey = yRowKey;
                    }
                    exceptions.add(new KeyedValues3DItemKey(seriesKey, rrKey, colKey));
                }
                if (nullConversion.equals((Object)NullConversion.THROW_EXCEPTION)) {
                    rrKey = zRowKey;
                    if (x == null) {
                        rrKey = yRowKey;
                    } else if (y == null) {
                        rrKey = yRowKey;
                    }
                    throw new RuntimeException("There is a null value for the item [" + seriesKey + ", " + rrKey + ", " + colKey + "].");
                }
                if (nullConversion == NullConversion.SKIP) continue;
                double xx = DataUtils.convert(x, nullConversion);
                double yy = DataUtils.convert(y, nullConversion);
                double zz = DataUtils.convert(z, nullConversion);
                series.add(xx, yy, zz);
            }
            dataset.add(series);
        }
        return dataset;
    }

    public static XYZDataset extractXYZDatasetFromColumns(KeyedValues3D<? extends Number> source, Comparable<?> xColKey, Comparable<?> yColKey, Comparable<?> zColKey) {
        return DataUtils.extractXYZDatasetFromColumns(source, xColKey, yColKey, zColKey, NullConversion.SKIP, null);
    }

    public static XYZDataset extractXYZDatasetFromColumns(KeyedValues3D<? extends Number> source, Comparable<?> xColKey, Comparable<?> yColKey, Comparable<?> zColKey, NullConversion nullConversion, List<KeyedValues3DItemKey> exceptions) {
        ArgChecks.nullNotPermitted(source, "source");
        ArgChecks.nullNotPermitted(xColKey, "xColKey");
        ArgChecks.nullNotPermitted(yColKey, "yColKey");
        ArgChecks.nullNotPermitted(zColKey, "zColKey");
        XYZSeriesCollection dataset = new XYZSeriesCollection();
        for (Comparable<?> seriesKey : source.getSeriesKeys()) {
            XYZSeries series = new XYZSeries(seriesKey);
            for (Comparable<?> rowKey : source.getRowKeys()) {
                Comparable<?> ccKey;
                Number x = source.getValue(seriesKey, rowKey, xColKey);
                Number y = source.getValue(seriesKey, rowKey, yColKey);
                Number z = source.getValue(seriesKey, rowKey, zColKey);
                if (x != null && y != null && z != null) {
                    series.add(x.doubleValue(), y.doubleValue(), z.doubleValue());
                    continue;
                }
                if (exceptions != null) {
                    ccKey = zColKey;
                    if (x == null) {
                        ccKey = xColKey;
                    } else if (y == null) {
                        ccKey = yColKey;
                    }
                    exceptions.add(new KeyedValues3DItemKey(seriesKey, rowKey, ccKey));
                }
                if (nullConversion.equals((Object)NullConversion.THROW_EXCEPTION)) {
                    ccKey = zColKey;
                    if (x == null) {
                        ccKey = xColKey;
                    } else if (y == null) {
                        ccKey = yColKey;
                    }
                    throw new RuntimeException("There is a null value for the item [" + seriesKey + ", " + rowKey + ", " + ccKey + "].");
                }
                if (nullConversion == NullConversion.SKIP) continue;
                double xx = DataUtils.convert(x, nullConversion);
                double yy = DataUtils.convert(y, nullConversion);
                double zz = DataUtils.convert(z, nullConversion);
                series.add(xx, yy, zz);
            }
            dataset.add(series);
        }
        return dataset;
    }

    private static double convert(Number n, NullConversion nullConversion) {
        if (n != null) {
            return n.doubleValue();
        }
        if (nullConversion.equals((Object)NullConversion.CONVERT_TO_ZERO)) {
            return 0.0;
        }
        return Double.NaN;
    }
}

