/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValues2D;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.KeyedValues2D;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.StandardPieDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.json.JSONValue;
import com.orsoncharts.util.json.parser.ContainerFactory;
import com.orsoncharts.util.json.parser.JSONParser;
import com.orsoncharts.util.json.parser.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static KeyedValues<? extends Number> readKeyedValues(String json) {
        KeyedValues<? extends Number> result;
        ArgChecks.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues<? extends Number> readKeyedValues(Reader reader) throws IOException {
        ArgChecks.nullNotPermitted(reader, "reader");
        try {
            JSONParser parser = new JSONParser();
            List list = (List)parser.parse(reader, JSONUtils.createContainerFactory());
            StandardPieDataset3D result = new StandardPieDataset3D();
            for (Object item : list) {
                List itemAsList = (List)item;
                result.add((Comparable)itemAsList.get(0), (Number)itemAsList.get(1));
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String writeKeyedValues(KeyedValues<? extends Number> data) {
        ArgChecks.nullNotPermitted(data, "data");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues(data, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues(KeyedValues<? extends Number> data, Writer writer) throws IOException {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(writer, "writer");
        writer.write("[");
        boolean first = true;
        for (Comparable<?> key : data.getKeys()) {
            if (!first) {
                writer.write(", ");
            } else {
                first = false;
            }
            writer.write("[");
            writer.write(JSONValue.toJSONString(key.toString()));
            writer.write(", ");
            writer.write(JSONValue.toJSONString(data.getValue(key)));
            writer.write("]");
        }
        writer.write("]");
    }

    public static KeyedValues2D<? extends Number> readKeyedValues2D(String json) {
        KeyedValues2D<? extends Number> result;
        ArgChecks.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues2D(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues2D<? extends Number> readKeyedValues2D(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Map map = (Map)parser.parse(reader, JSONUtils.createContainerFactory());
            DefaultKeyedValues2D result = new DefaultKeyedValues2D();
            if (map.isEmpty()) {
                return result;
            }
            Object keysObj = map.get("columnKeys");
            List keys = null;
            if (!(keysObj instanceof List)) {
                if (keysObj == null) {
                    throw new RuntimeException("No 'columnKeys' defined.");
                }
                throw new RuntimeException("Please check the 'columnKeys', the format does not parse to a list.");
            }
            keys = (List)keysObj;
            Object dataObj = map.get("rows");
            if (dataObj instanceof List) {
                List rowList = (List)dataObj;
                for (Object rowObj : rowList) {
                    JSONUtils.processRow(rowObj, keys, result);
                }
            } else {
                if (dataObj == null) {
                    throw new RuntimeException("No 'rows' section defined.");
                }
                throw new RuntimeException("Please check the 'rows' entry, the format does not parse to a list of rows.");
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void processRow(Object rowObj, List<?> columnKeys, DefaultKeyedValues2D dataset) {
        if (!(rowObj instanceof List)) {
            throw new RuntimeException("Check the 'data' section it contains a row that does not parse to a list.");
        }
        List rowList = (List)rowObj;
        Object rowKey = rowList.get(0);
        Object rowDataObj = rowList.get(1);
        if (!(rowDataObj instanceof List)) {
            throw new RuntimeException("Please check the row entry for " + rowKey + " because it is not parsing to a list (of " + "rowKey and rowDataValues items.");
        }
        List rowData = (List)rowDataObj;
        if (rowData.size() != columnKeys.size()) {
            throw new RuntimeException("The values list for series " + rowKey + " does not contain the correct number of " + "entries to match the columnKeys.");
        }
        for (int c = 0; c < rowData.size(); ++c) {
            Object columnKey = columnKeys.get(c);
            dataset.setValue(JSONUtils.objToDouble(rowData.get(c)), (Comparable<?>)((Object)rowKey.toString()), (Comparable<?>)((Object)columnKey.toString()));
        }
    }

    public static String writeKeyedValues2D(KeyedValues2D<? extends Number> data) {
        ArgChecks.nullNotPermitted(data, "data");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues2D(data, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues2D(KeyedValues2D<? extends Number> data, Writer writer) throws IOException {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(writer, "writer");
        List<Comparable<?>> columnKeys = data.getColumnKeys();
        List<Comparable<?>> rowKeys = data.getRowKeys();
        writer.write("{");
        if (!columnKeys.isEmpty()) {
            writer.write("\"columnKeys\": [");
            boolean first = true;
            for (Comparable<?> columnKey : columnKeys) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(columnKey.toString()));
            }
            writer.write("]");
        }
        if (!rowKeys.isEmpty()) {
            writer.write(", \"rows\": [");
            boolean firstRow = true;
            for (Comparable<?> rowKey : rowKeys) {
                if (!firstRow) {
                    writer.write(", [");
                } else {
                    writer.write("[");
                    firstRow = false;
                }
                writer.write(JSONValue.toJSONString(rowKey.toString()));
                writer.write(", [");
                boolean first = true;
                for (Comparable<?> columnKey : columnKeys) {
                    if (!first) {
                        writer.write(", ");
                    } else {
                        first = false;
                    }
                    writer.write(JSONValue.toJSONString(data.getValue(rowKey, columnKey)));
                }
                writer.write("]]");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    public static KeyedValues3D<? extends Number> readKeyedValues3D(String json) {
        KeyedValues3D<? extends Number> result;
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues3D(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues3D<? extends Number> readKeyedValues3D(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Map map = (Map)parser.parse(reader, JSONUtils.createContainerFactory());
            StandardCategoryDataset3D result = new StandardCategoryDataset3D();
            if (map.isEmpty()) {
                return result;
            }
            Object rowKeysObj = map.get("rowKeys");
            if (!(rowKeysObj instanceof List)) {
                if (rowKeysObj == null) {
                    throw new RuntimeException("No 'rowKeys' defined.");
                }
                throw new RuntimeException("Please check the 'rowKeys', the format does not parse to a list.");
            }
            List rowKeys = (List)rowKeysObj;
            Object columnKeysObj = map.get("columnKeys");
            if (!(columnKeysObj instanceof List)) {
                if (columnKeysObj == null) {
                    throw new RuntimeException("No 'columnKeys' defined.");
                }
                throw new RuntimeException("Please check the 'columnKeys', the format does not parse to a list.");
            }
            List columnKeys = (List)columnKeysObj;
            Object dataObj = map.get("data");
            if (dataObj instanceof List) {
                List seriesList = (List)dataObj;
                for (Object seriesObj : seriesList) {
                    JSONUtils.processSeries(seriesObj, rowKeys, columnKeys, result);
                }
            } else {
                if (dataObj == null) {
                    throw new RuntimeException("No 'data' section defined.");
                }
                throw new RuntimeException("Please check the 'data' entry, the format does not parse to a list of series.");
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void processSeries(Object seriesObj, List<?> rowKeys, List<?> columnKeys, StandardCategoryDataset3D dataset) {
        if (!(seriesObj instanceof Map)) {
            throw new RuntimeException("Check the 'data' section it contains a series that does not parse to a map.");
        }
        Map seriesMap = (Map)seriesObj;
        Object seriesKey = seriesMap.get("seriesKey");
        Object seriesRowsObj = seriesMap.get("rows");
        if (!(seriesRowsObj instanceof Map)) {
            throw new RuntimeException("Please check the series entry for " + seriesKey + " because it is not parsing to a map (of " + "rowKey -> rowDataValues items.");
        }
        Map seriesData = (Map)seriesRowsObj;
        for (Object rowKey : seriesData.keySet()) {
            if (!rowKeys.contains(rowKey)) {
                throw new RuntimeException("The row key " + rowKey + " is not " + "listed in the rowKeys entry.");
            }
            Object rowValuesObj = seriesData.get(rowKey);
            if (!(rowValuesObj instanceof List)) {
                throw new RuntimeException("Please check the entry for series " + seriesKey + " and row " + rowKey + " because it " + "does not parse to a list of values.");
            }
            List rowValues = (List)rowValuesObj;
            if (rowValues.size() != columnKeys.size()) {
                throw new RuntimeException("The values list for series " + seriesKey + " and row " + rowKey + " does not " + "contain the correct number of entries to match " + "the columnKeys.");
            }
            for (int c = 0; c < rowValues.size(); ++c) {
                Object columnKey = columnKeys.get(c);
                dataset.addValue(JSONUtils.objToDouble(rowValues.get(c)), (Comparable<?>)((Object)seriesKey.toString()), (Comparable<?>)((Object)rowKey.toString()), (Comparable<?>)((Object)columnKey.toString()));
            }
        }
    }

    public static String writeKeyedValues3D(KeyedValues3D<? extends Number> dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues3D(dataset, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues3D(KeyedValues3D<? extends Number> dataset, Writer writer) throws IOException {
        boolean first;
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArgChecks.nullNotPermitted(writer, "writer");
        writer.write("{");
        if (!dataset.getColumnKeys().isEmpty()) {
            writer.write("\"columnKeys\": [");
            first = true;
            for (Comparable<?> key : dataset.getColumnKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(key.toString()));
            }
            writer.write("], ");
        }
        if (!dataset.getRowKeys().isEmpty()) {
            writer.write("\"rowKeys\": [");
            first = true;
            for (Comparable<?> key : dataset.getRowKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(key.toString()));
            }
            writer.write("], ");
        }
        if (dataset.getSeriesCount() != 0) {
            writer.write("\"series\": [");
            first = true;
            for (Comparable<?> seriesKey : dataset.getSeriesKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write("{\"seriesKey\": ");
                writer.write(JSONValue.toJSONString(seriesKey.toString()));
                writer.write(", \"rows\": [");
                boolean firstRow = true;
                for (Comparable<?> rowKey : dataset.getRowKeys()) {
                    if (JSONUtils.countForRowInSeries(dataset, seriesKey, rowKey) <= 0) continue;
                    if (!firstRow) {
                        writer.write(", [");
                    } else {
                        writer.write("[");
                        firstRow = false;
                    }
                    writer.write(JSONValue.toJSONString(rowKey.toString()) + ", [");
                    for (int c = 0; c < dataset.getColumnCount(); ++c) {
                        Comparable<?> columnKey = dataset.getColumnKey(c);
                        if (c != 0) {
                            writer.write(", ");
                        }
                        writer.write(JSONValue.toJSONString(dataset.getValue(seriesKey, rowKey, columnKey)));
                    }
                    writer.write("]]");
                }
                writer.write("]}");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    private static int countForRowInSeries(KeyedValues3D<?> data, Comparable<?> seriesKey, Comparable<?> rowKey) {
        ArgChecks.nullNotPermitted(data, "data");
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        int rowIndex = data.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        int count = 0;
        for (int c = 0; c < data.getColumnCount(); ++c) {
            Number n = (Number)data.getValue(seriesIndex, rowIndex, c);
            if (n == null) continue;
            ++count;
        }
        return count;
    }

    public static XYZDataset readXYZDataset(String json) {
        XYZDataset result;
        ArgChecks.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readXYZDataset(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static XYZDataset readXYZDataset(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        XYZSeriesCollection result = new XYZSeriesCollection();
        try {
            List list = (List)parser.parse(reader, JSONUtils.createContainerFactory());
            for (Object seriesArray : list) {
                if (seriesArray instanceof List) {
                    List seriesList = (List)seriesArray;
                    XYZSeries series = JSONUtils.createSeries(seriesList);
                    result.add(series);
                    continue;
                }
                throw new RuntimeException("Input for a series did not parse to a list.");
            }
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static String writeXYZDataset(XYZDataset dataset) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeXYZDataset(dataset, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeXYZDataset(XYZDataset dataset, Writer writer) throws IOException {
        writer.write("[");
        boolean first = true;
        for (Comparable<?> seriesKey : dataset.getSeriesKeys()) {
            if (!first) {
                writer.write(", [");
            } else {
                writer.write("[");
                first = false;
            }
            writer.write(JSONValue.toJSONString(seriesKey.toString()));
            writer.write(", [");
            int seriesIndex = dataset.getSeriesIndex(seriesKey);
            int itemCount = dataset.getItemCount(seriesIndex);
            for (int i = 0; i < itemCount; ++i) {
                if (i != 0) {
                    writer.write(", ");
                }
                writer.write("[");
                writer.write(JSONValue.toJSONString(dataset.getX(seriesIndex, i)));
                writer.write(", ");
                writer.write(JSONValue.toJSONString(dataset.getY(seriesIndex, i)));
                writer.write(", ");
                writer.write(JSONValue.toJSONString(dataset.getZ(seriesIndex, i)));
                writer.write("]");
            }
            writer.write("]]");
        }
        writer.write("]");
    }

    private static double objToDouble(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        double result = Double.NaN;
        try {
            result = Double.valueOf(obj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static XYZSeries createSeries(List<?> sArray) {
        Comparable key = (Comparable)sArray.get(0);
        List dataItems = (List)sArray.get(1);
        XYZSeries series = new XYZSeries(key);
        for (Object item : dataItems) {
            if (item instanceof List) {
                List xyz = (List)item;
                if (xyz.size() != 3) {
                    throw new RuntimeException("A data item should contain three numbers, but we have " + xyz);
                }
                double x = JSONUtils.objToDouble(xyz.get(0));
                double y = JSONUtils.objToDouble(xyz.get(1));
                double z = JSONUtils.objToDouble(xyz.get(2));
                series.add(x, y, z);
                continue;
            }
            throw new RuntimeException("Expecting a data item (x, y, z) for series " + key + " but found " + item + ".");
        }
        return series;
    }

    private static ContainerFactory createContainerFactory() {
        return new ContainerFactory(){

            @Override
            public Map createObjectContainer() {
                return new LinkedHashMap();
            }

            @Override
            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
    }
}

