/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.AbstractDataset3D;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYZSeriesCollection
extends AbstractDataset3D
implements XYZDataset,
Serializable {
    private final List<XYZSeries> series = new ArrayList<XYZSeries>();

    @Override
    public int getSeriesCount() {
        return this.series.size();
    }

    @Override
    public int getSeriesIndex(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        return this.getSeriesKeys().indexOf(key);
    }

    @Override
    public List<Comparable<?>> getSeriesKeys() {
        ArrayList result = new ArrayList();
        for (XYZSeries s : this.series) {
            result.add(s.getKey());
        }
        return result;
    }

    @Override
    public Comparable<?> getSeriesKey(int seriesIndex) {
        return this.getSeries(seriesIndex).getKey();
    }

    public void add(XYZSeries series) {
        ArgChecks.nullNotPermitted(series, "series");
        if (this.getSeriesIndex(series.getKey()) >= 0) {
            throw new IllegalArgumentException("Another series with the same key already exists within the collection.");
        }
        this.series.add(series);
    }

    public XYZSeries getSeries(int index) {
        ArgChecks.checkArrayBounds(index, "index", this.series.size());
        return this.series.get(index);
    }

    public XYZSeries getSeries(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        for (XYZSeries s : this.series) {
            if (!s.getKey().equals(key)) continue;
            return s;
        }
        return null;
    }

    @Override
    public int getItemCount(int seriesIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getItemCount();
    }

    @Override
    public double getX(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getXValue(itemIndex);
    }

    @Override
    public double getY(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getYValue(itemIndex);
    }

    @Override
    public double getZ(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getZValue(itemIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZSeriesCollection)) {
            return false;
        }
        XYZSeriesCollection that = (XYZSeriesCollection)obj;
        return this.series.equals(that.series);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + ObjectUtils.hashCode(this.series);
        return hash;
    }

    public String toString() {
        return JSONUtils.writeXYZDataset(this);
    }
}

