/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Drawable3D;
import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.graphics3d.ZOrderComparator;
import com.orsoncharts.util.ArgChecks;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;

public class DefaultDrawable3D
implements Drawable3D {
    public static final double DEFAULT_PROJ_DIST = 1500.0;
    private ViewPoint3D viewPoint;
    private double projDist;
    private World world;
    private Offset2D offset;

    public DefaultDrawable3D(World world) {
        ArgChecks.nullNotPermitted(world, "world");
        this.viewPoint = new ViewPoint3D(4.71238899230957, 0.5235987901687622, 40.0, 0.0);
        this.projDist = 1500.0;
        this.world = world;
        this.offset = new Offset2D();
    }

    @Override
    public Dimension3D getDimensions() {
        return new Dimension3D(1.0, 1.0, 1.0);
    }

    @Override
    public ViewPoint3D getViewPoint() {
        return this.viewPoint;
    }

    @Override
    public void setViewPoint(ViewPoint3D viewPoint) {
        ArgChecks.nullNotPermitted(viewPoint, "viewPoint");
        this.viewPoint = viewPoint;
    }

    @Override
    public double getProjDistance() {
        return this.projDist;
    }

    @Override
    public void setProjDistance(double dist) {
        this.projDist = dist;
    }

    @Override
    public Offset2D getTranslate2D() {
        return this.offset;
    }

    @Override
    public void setTranslate2D(Offset2D offset) {
        ArgChecks.nullNotPermitted(offset, "offset");
        this.offset = offset;
    }

    @Override
    public RenderingInfo draw(Graphics2D g2, Rectangle2D bounds) {
        ArgChecks.nullNotPermitted(g2, "g2");
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setPaint(Color.WHITE);
        g2.fill(bounds);
        AffineTransform saved = g2.getTransform();
        double dx = bounds.getWidth() / 2.0;
        double dy = bounds.getHeight() / 2.0;
        g2.translate(dx, dy);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point3D[] eyePts = this.world.calculateEyeCoordinates(this.viewPoint);
        Point2D[] pts = this.world.calculateProjectedPoints(this.viewPoint, this.projDist);
        ArrayList<Face> facesInPaintOrder = new ArrayList<Face>(this.world.getFaces());
        Collections.sort(facesInPaintOrder, new ZOrderComparator(eyePts));
        for (Face f : facesInPaintOrder) {
            Color c;
            double[] plane = f.calculateNormal(eyePts);
            double inprod = plane[0] * this.world.getSunX() + plane[1] * this.world.getSunY() + plane[2] * this.world.getSunZ();
            double shade = (inprod + 1.0) / 2.0;
            if (!(Utils2D.area2(pts[f.getVertexIndex(0)], pts[f.getVertexIndex(1)], pts[f.getVertexIndex(2)]) > 0.0) || (c = f.getColor()) == null) continue;
            GeneralPath p = new GeneralPath();
            for (int v = 0; v < f.getVertexCount(); ++v) {
                if (v == 0) {
                    p.moveTo(pts[f.getVertexIndex(v)].getX(), pts[f.getVertexIndex(v)].getY());
                    continue;
                }
                p.lineTo(pts[f.getVertexIndex(v)].getX(), pts[f.getVertexIndex(v)].getY());
            }
            p.closePath();
            g2.setPaint(new Color((int)((double)c.getRed() * shade), (int)((double)c.getGreen() * shade), (int)((double)c.getBlue() * shade), c.getAlpha()));
            g2.fill(p);
            g2.draw(p);
        }
        g2.setTransform(saved);
        RenderingInfo info = new RenderingInfo(facesInPaintOrder, pts, dx, dy);
        return info;
    }
}

