/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.util.ArgChecks;

public class Line3D {
    private Point3D start;
    private Point3D end;

    public Line3D(Point3D start, Point3D end) {
        ArgChecks.nullNotPermitted(start, "start");
        ArgChecks.nullNotPermitted(end, "end");
        this.start = start;
        this.end = end;
    }

    public Line3D(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.start = new Point3D(x0, y0, z0);
        this.end = new Point3D(x1, y1, z1);
    }

    public Point3D getStart() {
        return this.start;
    }

    public Point3D getEnd() {
        return this.end;
    }

    public static Line3D cropLineToAxisAlignedBoundingBox(Line3D line, double x0, double x1, double y0, double y1, double z0, double z1) {
        Point3D p;
        double xx0 = line.getStart().getX();
        double xx1 = line.getEnd().getX();
        int kx0 = 2;
        if (xx0 < x0) {
            kx0 = 1;
        } else if (xx0 > x1) {
            kx0 = 4;
        }
        int kx1 = 2;
        if (xx1 < x0) {
            kx1 = 1;
        } else if (xx1 > x1) {
            kx1 = 4;
        }
        if ((kx0 | kx1) == 1 || (kx0 | kx1) == 4) {
            return null;
        }
        double yy0 = line.getStart().getY();
        double yy1 = line.getEnd().getY();
        int ky0 = 2;
        if (yy0 < y0) {
            ky0 = 1;
        } else if (yy0 > y1) {
            ky0 = 4;
        }
        int ky1 = 2;
        if (yy1 < y0) {
            ky1 = 1;
        } else if (yy1 > y1) {
            ky1 = 4;
        }
        if ((ky0 | ky1) == 1 || (ky0 | ky1) == 4) {
            return null;
        }
        double zz0 = line.getStart().getZ();
        double zz1 = line.getEnd().getZ();
        int kz0 = 2;
        if (zz0 < z0) {
            kz0 = 1;
        } else if (zz0 > z1) {
            kz0 = 4;
        }
        int kz1 = 2;
        if (zz1 < z0) {
            kz1 = 1;
        } else if (zz1 > z1) {
            kz1 = 4;
        }
        if ((kz0 | kz1) == 1 || (kz0 | kz1) == 4) {
            return null;
        }
        if ((kx0 | kx1 | ky0 | ky1 | kz0 | kz1) == 2) {
            return line;
        }
        Point3D firstValidPoint = null;
        if (Line3D.isPoint3DInBoundingBox(line.getStart(), x0, x1, y0, y1, z0, z1)) {
            firstValidPoint = line.getStart();
        }
        if (Line3D.isPoint3DInBoundingBox(line.getEnd(), x0, x1, y0, y1, z0, z1)) {
            firstValidPoint = line.getEnd();
        }
        if (((kx0 | kx1) & 1) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnX(line, x0), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        if (((kx0 | kx1) & 4) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnX(line, x1), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        if (((ky0 | ky1) & 1) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnY(line, y0), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        if (((ky0 | ky1) & 4) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnY(line, y1), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        if (((kz0 | kz1) & 1) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnZ(line, z0), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        if (((kz0 | kz1) & 4) != 0 && Line3D.isPoint3DInBoundingBox(p = Line3D.projectLineOnZ(line, z1), x0, x1, y0, y1, z0, z1)) {
            if (firstValidPoint == null) {
                firstValidPoint = p;
            } else {
                return new Line3D(firstValidPoint, p);
            }
        }
        return null;
    }

    private static Point3D projectLineOnX(Line3D line, double x) {
        double x0 = line.getStart().getX();
        double x1 = line.getEnd().getX();
        double factor = 0.0;
        if (Math.abs(x1 - x0) > 0.0) {
            factor = (x - x0) / (x1 - x0);
        }
        if (factor >= 1.0) {
            return line.getEnd();
        }
        if (factor <= 0.0) {
            return line.getStart();
        }
        double y0 = line.getStart().getY();
        double y1 = line.getEnd().getY();
        double z0 = line.getStart().getZ();
        double z1 = line.getEnd().getZ();
        return new Point3D(x0 + factor * (x1 - x0), y0 + factor * (y1 - y0), z0 + factor * (z1 - z0));
    }

    private static Point3D projectLineOnY(Line3D line, double y) {
        double y0 = line.getStart().getY();
        double y1 = line.getEnd().getY();
        double factor = 0.0;
        if (Math.abs(y1 - y0) > 0.0) {
            factor = (y - y0) / (y1 - y0);
        }
        if (factor >= 1.0) {
            return line.getEnd();
        }
        if (factor <= 0.0) {
            return line.getStart();
        }
        double x0 = line.getStart().getX();
        double x1 = line.getEnd().getX();
        double z0 = line.getStart().getZ();
        double z1 = line.getEnd().getZ();
        return new Point3D(x0 + factor * (x1 - x0), y0 + factor * (y1 - y0), z0 + factor * (z1 - z0));
    }

    private static Point3D projectLineOnZ(Line3D line, double z) {
        double z0 = line.getStart().getZ();
        double z1 = line.getEnd().getZ();
        double factor = 0.0;
        if (Math.abs(z1 - z0) > 0.0) {
            factor = (z - z0) / (z1 - z0);
        }
        if (factor >= 1.0) {
            return line.getEnd();
        }
        if (factor <= 0.0) {
            return line.getStart();
        }
        double x0 = line.getStart().getX();
        double x1 = line.getEnd().getX();
        double y0 = line.getStart().getY();
        double y1 = line.getEnd().getY();
        return new Point3D(x0 + factor * (x1 - x0), y0 + factor * (y1 - y0), z0 + factor * (z1 - z0));
    }

    private static boolean isPoint3DInBoundingBox(Point3D p, double x0, double x1, double y0, double y1, double z0, double z1) {
        double x = p.getX();
        if (x < x0) {
            return false;
        }
        if (x > x1) {
            return false;
        }
        double y = p.getY();
        if (y < y0) {
            return false;
        }
        if (y > y1) {
            return false;
        }
        double z = p.getZ();
        if (z < z0) {
            return false;
        }
        return !(z > z1);
    }
}

