/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Colors;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.util.Orientation;
import com.orsonpdf.PDFHints;
import java.awt.BasicStroke;
import java.awt.Color;

public class BarChart3D2 {
    public static Chart3D createChart(CategoryDataset3D dataset) {
        Chart3D chart = Chart3DFactory.createBarChart("Average Maximum Temperature", "http://www.worldclimateguide.co.uk/climateguides/", dataset, null, null, "Temp \u00b0C");
        chart.getRenderingHints().put(PDFHints.KEY_DRAW_STRING_TYPE, PDFHints.VALUE_DRAW_STRING_TYPE_VECTOR);
        chart.setLegendPosition(LegendAnchor.BOTTOM_RIGHT, Orientation.VERTICAL);
        chart.getViewPoint().panLeftRight(-0.05235987755982988);
        CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
        StandardCategoryAxis3D xAxis = (StandardCategoryAxis3D)plot.getColumnAxis();
        NumberAxis3D yAxis = (NumberAxis3D)plot.getValueAxis();
        StandardCategoryAxis3D zAxis = (StandardCategoryAxis3D)plot.getRowAxis();
        plot.setGridlineStrokeForValues(new BasicStroke(0.0f));
        xAxis.setLineColor(new Color(0, 0, 0, 0));
        yAxis.setLineColor(new Color(0, 0, 0, 0));
        zAxis.setLineColor(new Color(0, 0, 0, 0));
        plot.getRenderer().setColors(Colors.createPastelColors());
        plot.setToolTipGenerator(new StandardCategoryItemLabelGenerator("%2$s (%3$s) = %4$s degrees"));
        return chart;
    }

    public static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D dataset = new StandardCategoryDataset3D();
        DefaultKeyedValues<Integer> s3 = new DefaultKeyedValues<Integer>();
        s3.put((Comparable<?>)((Object)"Jan"), 7);
        s3.put((Comparable<?>)((Object)"Feb"), 7);
        s3.put((Comparable<?>)((Object)"Mar"), 10);
        s3.put((Comparable<?>)((Object)"Apr"), 13);
        s3.put((Comparable<?>)((Object)"May"), 17);
        s3.put((Comparable<?>)((Object)"Jun"), 20);
        s3.put((Comparable<?>)((Object)"Jul"), 22);
        s3.put((Comparable<?>)((Object)"Aug"), 21);
        s3.put((Comparable<?>)((Object)"Sep"), 19);
        s3.put((Comparable<?>)((Object)"Oct"), 15);
        s3.put((Comparable<?>)((Object)"Nov"), 10);
        s3.put((Comparable<?>)((Object)"Dec"), 8);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"London"), (KeyedValues<? extends Number>)s3);
        DefaultKeyedValues<Integer> s1 = new DefaultKeyedValues<Integer>();
        s1.put((Comparable<?>)((Object)"Jan"), 3);
        s1.put((Comparable<?>)((Object)"Feb"), 5);
        s1.put((Comparable<?>)((Object)"Mar"), 9);
        s1.put((Comparable<?>)((Object)"Apr"), 14);
        s1.put((Comparable<?>)((Object)"May"), 18);
        s1.put((Comparable<?>)((Object)"Jun"), 22);
        s1.put((Comparable<?>)((Object)"Jul"), 25);
        s1.put((Comparable<?>)((Object)"Aug"), 24);
        s1.put((Comparable<?>)((Object)"Sep"), 20);
        s1.put((Comparable<?>)((Object)"Oct"), 14);
        s1.put((Comparable<?>)((Object)"Nov"), 8);
        s1.put((Comparable<?>)((Object)"Dec"), 4);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Geneva"), (KeyedValues<? extends Number>)s1);
        DefaultKeyedValues<Integer> s2 = new DefaultKeyedValues<Integer>();
        s2.put((Comparable<?>)((Object)"Jan"), 9);
        s2.put((Comparable<?>)((Object)"Feb"), 11);
        s2.put((Comparable<?>)((Object)"Mar"), 13);
        s2.put((Comparable<?>)((Object)"Apr"), 16);
        s2.put((Comparable<?>)((Object)"May"), 20);
        s2.put((Comparable<?>)((Object)"Jun"), 23);
        s2.put((Comparable<?>)((Object)"Jul"), 26);
        s2.put((Comparable<?>)((Object)"Aug"), 26);
        s2.put((Comparable<?>)((Object)"Sep"), 24);
        s2.put((Comparable<?>)((Object)"Oct"), 19);
        s2.put((Comparable<?>)((Object)"Nov"), 13);
        s2.put((Comparable<?>)((Object)"Dec"), 9);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Bergerac"), (KeyedValues<? extends Number>)s2);
        DefaultKeyedValues<Integer> s4 = new DefaultKeyedValues<Integer>();
        s4.put((Comparable<?>)((Object)"Jan"), 22);
        s4.put((Comparable<?>)((Object)"Feb"), 22);
        s4.put((Comparable<?>)((Object)"Mar"), 20);
        s4.put((Comparable<?>)((Object)"Apr"), 17);
        s4.put((Comparable<?>)((Object)"May"), 14);
        s4.put((Comparable<?>)((Object)"Jun"), 11);
        s4.put((Comparable<?>)((Object)"Jul"), 11);
        s4.put((Comparable<?>)((Object)"Aug"), 12);
        s4.put((Comparable<?>)((Object)"Sep"), 14);
        s4.put((Comparable<?>)((Object)"Oct"), 17);
        s4.put((Comparable<?>)((Object)"Nov"), 19);
        s4.put((Comparable<?>)((Object)"Dec"), 21);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Christchurch"), (KeyedValues<? extends Number>)s4);
        DefaultKeyedValues<Integer> s5 = new DefaultKeyedValues<Integer>();
        s5.put((Comparable<?>)((Object)"Jan"), 20);
        s5.put((Comparable<?>)((Object)"Feb"), 20);
        s5.put((Comparable<?>)((Object)"Mar"), 19);
        s5.put((Comparable<?>)((Object)"Apr"), 17);
        s5.put((Comparable<?>)((Object)"May"), 14);
        s5.put((Comparable<?>)((Object)"Jun"), 12);
        s5.put((Comparable<?>)((Object)"Jul"), 11);
        s5.put((Comparable<?>)((Object)"Aug"), 12);
        s5.put((Comparable<?>)((Object)"Sep"), 13);
        s5.put((Comparable<?>)((Object)"Oct"), 15);
        s5.put((Comparable<?>)((Object)"Nov"), 17);
        s5.put((Comparable<?>)((Object)"Dec"), 19);
        dataset.addSeriesAsRow((Comparable<?>)((Object)"Wellington"), (KeyedValues<? extends Number>)s5);
        return dataset;
    }
}

