/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Range;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.renderer.xyz.StandardXYZColorSource;
import java.awt.Color;

public class HighlightXYZColorSource
extends StandardXYZColorSource {
    private XYZDataset dataset;
    private Range xRange;
    private Range yRange;
    private Range zRange;
    private Color highlightColor;

    public HighlightXYZColorSource(XYZDataset dataset, Color highlightColor, Range xRange, Range yRange, Range zRange, Color ... colors) {
        super(colors);
        this.dataset = dataset;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.highlightColor = highlightColor;
    }

    @Override
    public Color getColor(int series, int item) {
        double x = this.dataset.getX(series, item);
        double y = this.dataset.getY(series, item);
        double z = this.dataset.getZ(series, item);
        if (this.xRange.contains(x) && this.yRange.contains(y) && this.zRange.contains(z)) {
            return this.highlightColor;
        }
        return super.getColor(series, item);
    }
}

