/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Colors;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.label.StandardXYZLabelGenerator;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;

public class ScatterPlot3D1 {
    public static Chart3D createChart(XYZDataset dataset) {
        Chart3D chart = Chart3DFactory.createScatterChart("ScatterPlot3DDemo1", "Chart created with Orson Charts", dataset, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(10.0, 4.0, 4.0));
        plot.setLegendLabelGenerator(new StandardXYZLabelGenerator("%s (%2$,d)"));
        ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
        renderer.setSize(0.15);
        renderer.setColors(Colors.createIntenseColors());
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        return chart;
    }

    public static XYZDataset createDataset() {
        XYZSeries s1 = ScatterPlot3D1.createRandomSeries("S1", 10);
        XYZSeries s2 = ScatterPlot3D1.createRandomSeries("S2", 50);
        XYZSeries s3 = ScatterPlot3D1.createRandomSeries("S3", 150);
        XYZSeriesCollection dataset = new XYZSeriesCollection();
        dataset.add(s1);
        dataset.add(s2);
        dataset.add(s3);
        return dataset;
    }

    private static XYZSeries createRandomSeries(String name, int count) {
        XYZSeries s = new XYZSeries((Comparable<?>)((Object)name));
        for (int i = 0; i < count; ++i) {
            s.add(Math.random() * 100.0, Math.random() / 100.0, Math.random() * 100.0);
        }
        return s;
    }
}

