/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.data.Dataset3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.demo.AreaChart3D1;
import com.orsoncharts.demo.DemoDescription;
import com.orsoncharts.demo.SampleData;
import com.orsoncharts.fx.Chart3DCanvas;
import com.orsoncharts.fx.Chart3DViewer;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Drawable3D;
import com.orsoncharts.interaction.fx.FXChart3DMouseEvent;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class OrsonChartsFXDemo
extends Application {
    private static final String PREFIX = "com.orsoncharts.demo.fx.";
    private Map<String, DemoDescription> descriptions = new HashMap<String, DemoDescription>();
    private SplitPane splitter;
    private WebView chartDescription;
    private static final String ABOUT_PREFIX = "/com/orsoncharts/demo/";
    private double margin = 0.25;

    public void start(Stage stage) throws Exception {
        TabPane tabPane = new TabPane();
        Tab tab1 = new Tab();
        tab1.setText("Demos");
        tab1.setClosable(false);
        SplitPane sp = new SplitPane();
        StackPane sp1 = new StackPane();
        sp1.getChildren().add((Object)this.createTreeView());
        BorderPane sp2 = new BorderPane();
        sp2.setCenter((Node)this.createChartPane());
        sp.getItems().addAll((Object[])new Node[]{sp1, sp2});
        sp.setDividerPositions(new double[]{0.3f, 0.6f});
        tab1.setContent((Node)sp);
        tabPane.getTabs().add((Object)tab1);
        Tab tab2 = new Tab();
        tab2.setText("About");
        tab2.setClosable(false);
        WebView browser = new WebView();
        WebEngine webEngine = browser.getEngine();
        webEngine.load(((Object)((Object)this)).getClass().getResource("/com/orsoncharts/demo/about.html").toString());
        tab2.setContent((Node)browser);
        tabPane.getTabs().add((Object)tab2);
        Scene scene = new Scene((Parent)tabPane, 1024.0, 768.0);
        stage.setScene(scene);
        stage.setTitle("Orson Charts JavaFX Demo");
        stage.show();
    }

    private StackPane createTreeView() {
        TreeItem rootItem = new TreeItem((Object)"Orson Charts", null);
        rootItem.setExpanded(true);
        TreeItem categoryChartsNode = new TreeItem((Object)"Category Charts");
        categoryChartsNode.setExpanded(true);
        rootItem.getChildren().add((Object)categoryChartsNode);
        DemoDescription d = new DemoDescription("com.orsoncharts.demo.fx.AreaChart3DFXDemo1", "AreaChart3DFXDemo1.java", "/com/orsoncharts/demo/AreaChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        TreeItem n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.AreaChart3DFXDemo2", "AreaChart3DFXDemo2.java", "/com/orsoncharts/demo/AreaChart3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.BarChart3DFXDemo1", "BarChart3DFXDemo1.java", "/com/orsoncharts/demo/BarChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.BarChart3DFXDemo2", "BarChart3DFXDemo2.java", "/com/orsoncharts/demo/BarChart3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.CategoryMarkerFXDemo1", "CategoryMarkerFXDemo1.java", "/com/orsoncharts/demo/CategoryMarkerDemo1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.LineChart3DFXDemo1", "LineChart3DFXDemo1.java", "/com/orsoncharts/demo/LineChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.LineChart3DFXDemo2", "LineChart3DFXDemo2.java", "/com/orsoncharts/demo/LineChart3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.StackedBarChart3DFXDemo1", "StackedBarChart3DFXDemo1.java", "/com/orsoncharts/demo/StackedBarChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.StackedBarChart3DFXDemo2", "StackedBarChart3DFXDemo2.java", "/com/orsoncharts/demo/StackedBarChart3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.StackedBarChart3DFXDemo3", "StackedBarChart3DFXDemo3.java", "/com/orsoncharts/demo/StackedBarChart3D3.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        categoryChartsNode.getChildren().add((Object)n);
        TreeItem pieChartsNode = new TreeItem((Object)"Pie Charts");
        rootItem.getChildren().add((Object)pieChartsNode);
        d = new DemoDescription("com.orsoncharts.demo.fx.PieChart3DFXDemo1", "PieChart3DFXDemo1.java", "/com/orsoncharts/demo/PieChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        pieChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.PieChart3DFXDemo2", "PieChart3DFXDemo2.java", "/com/orsoncharts/demo/PieChart3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        pieChartsNode.getChildren().add((Object)n);
        TreeItem xyzChartsNode = new TreeItem((Object)"XYZ Charts");
        rootItem.getChildren().add((Object)xyzChartsNode);
        d = new DemoDescription("com.orsoncharts.demo.fx.RangeMarkerFXDemo1", "RangeMarkerFXDemo1.java", "/com/orsoncharts/demo/RangeMarker1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.ScatterPlot3DFXDemo1", "ScatterPlot3DFXDemo1.java", "/com/orsoncharts/demo/ScatterPlot3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.ScatterPlot3DFXDemo2", "ScatterPlot3DFXDemo2.java", "/com/orsoncharts/demo/ScatterPlot3D2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.ScatterPlot3DFXDemo3", "ScatterPlot3DFXDemo3.java", "/com/orsoncharts/demo/ScatterPlot3D3.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.SurfaceRendererFXDemo1", "SurfaceRendererFXDemo1.java", "/com/orsoncharts/demo/SurfaceRenderer1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.SurfaceRendererFXDemo2", "SurfaceRendererFXDemo2.java", "/com/orsoncharts/demo/SurfaceRenderer2.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.XYZBarChart3DFXDemo1", "XYZBarChart3DFXDemo1.java", "/com/orsoncharts/demo/XYZBarChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        d = new DemoDescription("com.orsoncharts.demo.fx.XYZLineChart3DFXDemo1", "XYZLineChart3DFXDemo1.java", "/com/orsoncharts/demo/XYZLineChart3D1.html");
        this.descriptions.put(d.getFileName(), d);
        n = new TreeItem((Object)d.getFileName());
        xyzChartsNode.getChildren().add((Object)n);
        TreeView tree = new TreeView(rootItem);
        tree.getSelectionModel().selectedItemProperty().addListener((observableValue, oldItem, newItem) -> this.selectDemo((String)newItem.getValue()));
        StackPane root = new StackPane();
        root.getChildren().add((Object)tree);
        return root;
    }

    private Method getMethod(String name, Class c) {
        Method[] methods;
        for (Method method : methods = c.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public void zoomToFit(Drawable3D drawable, Dimension size) {
        int w = (int)(size.getWidth() * (1.0 - this.margin));
        int h = (int)(size.getHeight() * (1.0 - this.margin));
        Dimension target = new Dimension(w, h);
        Dimension3D d3d = drawable.getDimensions();
        float distance = drawable.getViewPoint().optimalDistance(target, d3d, drawable.getProjDistance());
        drawable.getViewPoint().setRho(distance);
    }

    private void selectDemo(String name) {
        DemoDescription demoDesc = this.descriptions.get(name);
        if (demoDesc != null) {
            try {
                Method m0;
                Object c;
                BorderPane borderPane = (BorderPane)this.splitter.getItems().get(0);
                Node oldnode = borderPane.getCenter();
                if (oldnode instanceof Chart3DViewer) {
                    c = (Chart3DViewer)oldnode;
                    c.prefWidthProperty().unbind();
                    c.prefHeightProperty().unbind();
                }
                if ((m0 = this.getMethod("createDemoNode", (Class)(c = Class.forName(demoDesc.getClassName())))) != null) {
                    Node node = (Node)m0.invoke(null, (Object[])null);
                    borderPane.setCenter(node);
                    if (node instanceof Chart3DViewer) {
                        Chart3DViewer v = (Chart3DViewer)node;
                        v.addEventHandler(FXChart3DMouseEvent.MOUSE_CLICKED, event -> System.out.println(event.getElement()));
                        v.prefWidthProperty().bind((ObservableValue)borderPane.widthProperty());
                        v.prefHeightProperty().bind((ObservableValue)borderPane.heightProperty());
                        this.zoomToFit(v.getChart(), new Dimension((int)borderPane.getWidth(), (int)borderPane.getHeight()));
                    }
                } else {
                    Method m1 = this.getMethod("createDataset", (Class)c);
                    Method m2 = this.getMethod("createChart", (Class)c);
                    Dataset3D dataset = (Dataset3D)m1.invoke(null, (Object[])null);
                    Chart3D chart = (Chart3D)m2.invoke(null, dataset);
                    Chart3DCanvas canvas = new Chart3DCanvas(chart);
                    borderPane.setCenter((Node)canvas);
                    canvas.widthProperty().bind((ObservableValue)borderPane.widthProperty());
                    canvas.heightProperty().bind((ObservableValue)borderPane.heightProperty());
                    canvas.zoomToFit(canvas.getWidth(), canvas.getHeight());
                }
                String urlStr = ((Class)c).getResource(demoDesc.getDescriptionFileName()).toString();
                this.chartDescription.getEngine().load(urlStr);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(OrsonChartsFXDemo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(OrsonChartsFXDemo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(OrsonChartsFXDemo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(OrsonChartsFXDemo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(OrsonChartsFXDemo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private SplitPane createChartPane() {
        CategoryDataset3D dataset = SampleData.createCompanyRevenueDataset();
        Chart3D chart = AreaChart3D1.createChart(dataset);
        Chart3DViewer viewer = new Chart3DViewer(chart);
        this.splitter = new SplitPane();
        this.splitter.setOrientation(Orientation.VERTICAL);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)viewer);
        viewer.prefWidthProperty().bind((ObservableValue)borderPane.widthProperty());
        viewer.prefHeightProperty().bind((ObservableValue)borderPane.heightProperty());
        StackPane sp2 = new StackPane();
        this.chartDescription = new WebView();
        WebEngine webEngine = this.chartDescription.getEngine();
        webEngine.load(AreaChart3D1.class.getResource("AreaChart3D1.html").toString());
        sp2.getChildren().add((Object)this.chartDescription);
        this.splitter.getItems().addAll((Object[])new Node[]{borderPane, sp2});
        this.splitter.setDividerPositions(new double[]{0.7f, 0.3f});
        return this.splitter;
    }

    public static void main(String[] args) {
        OrsonChartsFXDemo.launch((String[])args);
    }
}

