/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.TitleAnchor;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.data.PieDataset3D;
import com.orsoncharts.data.StandardPieDataset3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.marker.RangeMarker;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import com.orsoncharts.util.Orientation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.graphics2d.svg.SVGGraphics2D;

public class SVGDemo1 {
    static String generateSVGForChart(Chart3D chart, int width, int height, String defsPrefix) {
        SVGGraphics2D g2 = new SVGGraphics2D(width, height);
        g2.setDefsKeyPrefix(defsPrefix);
        chart.setElementHinting(true);
        chart.draw((Graphics2D)g2, new Rectangle(width, height));
        return g2.getSVGElement(chart.getID());
    }

    static PieDataset3D<String> createPieChartDataset() {
        StandardPieDataset3D<String> dataset = new StandardPieDataset3D<String>();
        dataset.add("Milk Products", 11625.0);
        dataset.add("Meat", 5114.0);
        dataset.add("Wood/Logs", 3060.0);
        dataset.add("Crude Oil", 2023.0);
        dataset.add("Machinery", 1865.0);
        dataset.add("Fruit", 1587.0);
        dataset.add("Fish", 1367.0);
        dataset.add("Wine", 1177.0);
        dataset.add("Other", 18870.0);
        return dataset;
    }

    static Chart3D createPieChart(String id) {
        Chart3D chart = Chart3DFactory.createPieChart("New Zealand Exports 2012", "http://www.stats.govt.nz/browse_for_stats/snapshots-of-nz/nz-in-profile-2013.aspx", SVGDemo1.createPieChartDataset());
        chart.setID(id);
        chart.setTitleAnchor(TitleAnchor.TOP_LEFT);
        chart.setLegendPosition(LegendAnchor.BOTTOM_CENTER, Orientation.HORIZONTAL);
        return chart;
    }

    private static CategoryDataset3D createBarChartDataset() {
        StandardCategoryDataset3D dataset = new StandardCategoryDataset3D();
        DefaultKeyedValues<String, Double> s1 = new DefaultKeyedValues<String, Double>();
        s1.put("Q2/11", 8.181);
        s1.put("Q3/11", 8.792);
        s1.put("Q4/11", 9.039);
        s1.put("Q1/12", 10.916);
        s1.put("Q2/12", 8.181);
        s1.put("Q3/12", 9.094);
        s1.put("Q4/12", 8.958);
        s1.put("Q1/13", 10.947);
        s1.put("Q2/13", 8.372);
        s1.put("Q3/13", 9.275);
        dataset.addSeriesAsRow("Oracle", s1);
        DefaultKeyedValues<String, Double> s2 = new DefaultKeyedValues<String, Double>();
        s2.put("Q2/11", 9.03);
        s2.put("Q3/11", 9.72);
        s2.put("Q4/11", 10.58);
        s2.put("Q1/12", 10.65);
        s2.put("Q2/12", 12.214);
        s2.put("Q3/12", 14.101);
        s2.put("Q4/12", 14.419);
        s2.put("Q1/13", 13.969);
        s2.put("Q2/13", 14.105);
        s2.put("Q3/13", 14.893);
        s2.put("Q4/13", 16.858);
        dataset.addSeriesAsRow("Google", s2);
        DefaultKeyedValues<String, Double> s3 = new DefaultKeyedValues<String, Double>();
        s3.put("Q2/11", 17.37);
        s3.put("Q3/11", 17.37);
        s3.put("Q4/11", 20.89);
        s3.put("Q1/12", 17.41);
        s3.put("Q2/12", 18.06);
        s3.put("Q3/12", 16.008);
        s3.put("Q4/12", 21.456);
        s3.put("Q1/13", 20.489);
        s3.put("Q2/13", 19.896);
        s3.put("Q3/13", 18.529);
        s3.put("Q4/13", 24.519);
        dataset.addSeriesAsRow("Microsoft", s3);
        DefaultKeyedValues<String, Double> s4 = new DefaultKeyedValues<String, Double>();
        s4.put("Q2/11", 28.57);
        s4.put("Q3/11", 28.27);
        s4.put("Q4/11", 46.33);
        s4.put("Q1/12", 39.2);
        s4.put("Q2/12", 35.0);
        s4.put("Q3/12", 36.0);
        s4.put("Q4/12", 54.5);
        s4.put("Q1/13", 43.6);
        s4.put("Q2/13", 35.323);
        s4.put("Q3/13", 37.5);
        s4.put("Q4/13", 57.594);
        dataset.addSeriesAsRow("Apple", s4);
        return dataset;
    }

    static Chart3D createBarChart(String id) {
        CategoryDataset3D dataset = SVGDemo1.createBarChartDataset();
        Chart3D chart = Chart3DFactory.createBarChart("Quarterly Revenues", "For some large IT companies", dataset, null, "Quarter", "$billion Revenues");
        chart.setID(id);
        chart.setChartBoxColor(new Color(255, 255, 255, 127));
        chart.setLegendAnchor(LegendAnchor.BOTTOM_RIGHT);
        CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
        plot.setGridlinePaintForValues(Color.BLACK);
        StandardCategoryAxis3D rowAxis = (StandardCategoryAxis3D)plot.getRowAxis();
        CategoryMarker rowMarker = new CategoryMarker((Comparable<?>)((Object)"Apple"));
        rowAxis.setMarker("Apple", rowMarker);
        StandardCategoryAxis3D columnAxis = (StandardCategoryAxis3D)plot.getColumnAxis();
        CategoryMarker columnMarker = new CategoryMarker((Comparable<?>)((Object)"Q4/12"));
        columnAxis.setMarker("Q4/12", columnMarker);
        chart.getViewPoint().setRho(1.3 * chart.getViewPoint().getRho());
        return chart;
    }

    private static XYZDataset<String> createScatterDataset(String xKey, String yKey, String zKey) {
        KeyedValues3D<String, String, String, Number> data;
        InputStreamReader in = new InputStreamReader(SVGDemo1.class.getResourceAsStream("iris.txt"));
        try {
            data = JSONUtils.readKeyedValues3D(in);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return DataUtils.extractXYZDatasetFromColumns(data, xKey, yKey, zKey);
    }

    static Chart3D createScatterChart(String id) {
        XYZDataset<String> dataset = SVGDemo1.createScatterDataset("sepal length", "sepal width", "petal length");
        Chart3D chart = Chart3DFactory.createScatterChart("Iris Dataset", null, dataset, "Sepal Length", "Sepal Width", "Petal Length");
        chart.setID(id);
        chart.setLegendAnchor(LegendAnchor.BOTTOM_LEFT);
        chart.setLegendOrientation(Orientation.VERTICAL);
        XYZPlot plot = (XYZPlot)chart.getPlot();
        NumberAxis3D yAxis = (NumberAxis3D)plot.getYAxis();
        RangeMarker marker1 = new RangeMarker(3.5, 4.0);
        yAxis.setMarker("M1", marker1);
        ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
        renderer.setSize(0.15);
        chart.getViewPoint().panLeftRight(0.2617993877991494);
        chart.getViewPoint().roll(0.2617993877991494);
        chart.getViewPoint().setRho(1.6 * chart.getViewPoint().getRho());
        return chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream("SVGDemo1.html");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            writer = new BufferedWriter(osw);
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<head>\n");
            writer.write("<title>SVG Demo 1</title>\n");
            writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n");
            writer.write("<script src=\"lib/opentip-native.js\"></script>");
            writer.write("<link href=\"css/opentip.css\" rel=\"stylesheet\" type=\"text/css\" />");
            writer.write("<script src=\"lib/orsoncharts.js\"></script>");
            writer.write("</head>\n");
            writer.write("<body>\n");
            writer.write("<h1>SVG Chart Demo</h1>\n");
            writer.write("<p>Click on an item in the chart or just hover and look at the tooltip (the ");
            writer.write("reference is a string in JSON format that should contain enough information to ");
            writer.write("identify the chart element):</p>\n");
            writer.write("  <script type=\"application/javascript\">\n");
            writer.write("    function pieChartData() {\n");
            writer.write("      return " + JSONUtils.writeKeyedValues(SVGDemo1.createPieChartDataset()) + "\n");
            writer.write("    }\n");
            writer.write("  </script>\n");
            writer.write("  <script type=\"application/javascript\">\n");
            writer.write("    function barChartData() {\n");
            writer.write("      return " + JSONUtils.writeKeyedValues3D(SVGDemo1.createBarChartDataset()) + "\n");
            writer.write("    }\n");
            writer.write("  </script>\n");
            writer.write("  <script type=\"application/javascript\">\n");
            writer.write("    function scatterChartData() {\n");
            XYZDataset<String> dataset = SVGDemo1.createScatterDataset("sepal length", "sepal width", "petal length");
            writer.write("      return " + JSONUtils.writeXYZDataset(dataset) + "\n");
            writer.write("    }\n");
            writer.write("  </script>\n");
            writer.write("  <script type=\"application/javascript\">\n");
            writer.write("    // wait until all the resources are loaded\n");
            writer.write("    window.addEventListener(\"load\", initialise, false);\n");
            writer.write("    function initialise() {\n");
            writer.write("      orsoncharts.pieDataset = new orsoncharts.KeyedValuesDataset();\n");
            writer.write("      orsoncharts.pieDataset.data = pieChartData();\n");
            writer.write("      orsoncharts.pieLabelGenerator = new orsoncharts.KeyedValueLabels();\n");
            writer.write("      orsoncharts.pieLabelGenerator.valueDP = 0;\n");
            writer.write("      orsoncharts.pieLabelGenerator.format = \"{K} = NZ${V} million\";\n");
            writer.write("      orsoncharts.barDataset = new orsoncharts.KeyedValues3DDataset();\n");
            writer.write("      orsoncharts.barDataset.data = barChartData();\n");
            writer.write("      orsoncharts.barLabelGenerator = new orsoncharts.KeyedValue3DLabels();\n");
            writer.write("      orsoncharts.barLabelGenerator.format = \"{R}, {C} = US${V} billion\";\n");
            writer.write("      orsoncharts.scatterDataset = new orsoncharts.XYZDataset();\n");
            writer.write("      orsoncharts.scatterDataset.data.series = scatterChartData();\n");
            writer.write("      orsoncharts.scatterLabelGenerator = new orsoncharts.XYZLabels();\n");
            writer.write("      orsoncharts.scatterLabelGenerator.format = \"{S} = ({X}, {Y}, {Z})\";\n");
            writer.write("      var pieSVG = document.getElementById(\"PieChart1\");\n");
            writer.write("      pieSVG.onmouseover = handleMouseOver;\n");
            writer.write("      pieSVG.onclick = handleClick;\n");
            writer.write("      var barSVG = document.getElementById(\"BarChart1\");\n");
            writer.write("      barSVG.onmouseover = handleMouseOver;\n");
            writer.write("      barSVG.onclick = handleClick;\n");
            writer.write("      var scatterSVG = document.getElementById(\"ScatterChart1\");\n");
            writer.write("      scatterSVG.onmouseover = handleMouseOver;\n");
            writer.write("      scatterSVG.onclick = handleClick;\n");
            writer.write("    }\n");
            writer.write("    function handleClick(evt) {\n");
            writer.write("      var element = evt.target;\n");
            writer.write("      var ref = orsoncharts.Utils.findChartRef(element);\n");
            writer.write("      var chartId = orsoncharts.Utils.findChartId(element);\n");
            writer.write("      alert('You clicked on the item ' + ref + ' for the chart [' + chartId + ']');\n");
            writer.write("    }\n");
            writer.write("    function handleMouseOver(evt) {\n");
            writer.write("      var element = evt.target;\n");
            writer.write("      var ref = orsoncharts.Utils.findChartRef(element);\n");
            writer.write("      var content;\n");
            writer.write("      var chartId = orsoncharts.Utils.findChartId(element);\n");
            writer.write("      if (ref != null && ref != 'ORSON_CHART_TOP_LEVEL') {\n");
            writer.write("        var refObj = JSON.parse(ref);\n");
            writer.write("        if (Opentip.tips.length < 1) {\n");
            writer.write("          myOpentip = new Opentip(element, \"content\");\n");
            writer.write("        } else {\n");
            writer.write("          myOpentip = Opentip.tips[0];\n");
            writer.write("        }\n");
            writer.write("        myOpentip.target = element;\n");
            writer.write("        if (chartId == \"PieChart1\") {\n");
            writer.write("          if (refObj.hasOwnProperty(\"key\")) {\n");
            writer.write("             var itemIndex = orsoncharts.pieDataset.indexOf(refObj.key);\n");
            writer.write("             content = orsoncharts.pieLabelGenerator.itemLabel(orsoncharts.pieDataset, itemIndex);\n");
            writer.write("          } else { content = ref; }\n");
            writer.write("        } else if (chartId == \"BarChart1\") {\n");
            writer.write("          if (!refObj.hasOwnProperty(\"type\")) {\n");
            writer.write("            var seriesIndex = orsoncharts.barDataset.seriesIndex(refObj.seriesKey);\n");
            writer.write("            var rowIndex = orsoncharts.barDataset.rowIndex(refObj.rowKey);\n");
            writer.write("            var columnIndex = orsoncharts.barDataset.columnIndex(refObj.columnKey);\n");
            writer.write("            content = orsoncharts.barLabelGenerator.itemLabel(orsoncharts.barDataset, seriesIndex, rowIndex, columnIndex);\n");
            writer.write("          } else {\n");
            writer.write("          content = ref + \" for bar chart.\";\n");
            writer.write("          }\n");
            writer.write("        } else if (chartId == \"ScatterChart1\") {\n");
            writer.write("          if (!refObj.hasOwnProperty(\"type\")) {\n");
            writer.write("            content = orsoncharts.scatterLabelGenerator.itemLabel(orsoncharts.scatterDataset, refObj.seriesKey, refObj.itemIndex);\n");
            writer.write("          } else {\n");
            writer.write("            content = ref + \" for scatter plot.\";\n");
            writer.write("          }\n");
            writer.write("        }\n");
            writer.write("        myOpentip.setContent(content);\n");
            writer.write("        myOpentip.reposition();\n");
            writer.write("        myOpentip.show();\n");
            writer.write("      }\n");
            writer.write("    }\n");
            writer.write("</script>\n");
            writer.write("<p>\n");
            Chart3D pieChart = SVGDemo1.createPieChart("PieChart1");
            writer.write(SVGDemo1.generateSVGForChart(pieChart, 600, 370, "defs1_") + "\n");
            writer.write("</p>\n");
            writer.write("<p>\n");
            Chart3D barChart = SVGDemo1.createBarChart("BarChart1");
            writer.write(SVGDemo1.generateSVGForChart(barChart, 600, 370, "defs2_") + "\n");
            writer.write("</p>\n");
            writer.write("<p>\n");
            Chart3D scatterChart = SVGDemo1.createScatterChart("ScatterChart1");
            writer.write(SVGDemo1.generateSVGForChart(scatterChart, 600, 370, "defs3_") + "\n");
            writer.write("</p>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
            writer.flush();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SVGDemo1.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

