/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Colors;
import com.orsoncharts.axis.LabelOrientation;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.label.StandardCategoryLabelGenerator;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.StackedBarRenderer3D;
import com.orsoncharts.table.StandardRectanglePainter;
import com.orsoncharts.util.Fit2D;
import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;

public class StackedBarChart3D3 {
    public static Chart3D createChart(CategoryDataset3D dataset) {
        Chart3D chart = Chart3DFactory.createStackedBarChart("The Sinking of the Titanic", "Survival data for 2,201 passengers", dataset, null, "Class", "Passengers");
        URL imageURL = StackedBarChart3D3.class.getResource("iStock_000003105870Small.jpg");
        ImageIcon icon = new ImageIcon(imageURL);
        StandardRectanglePainter background = new StandardRectanglePainter(Color.WHITE, icon.getImage(), Fit2D.SCALE_TO_FIT_TARGET);
        chart.setBackground(background);
        chart.setChartBoxColor(new Color(255, 255, 255, 155));
        CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
        plot.setLegendLabelGenerator(new StandardCategoryLabelGenerator("%s (%3$,.0f)"));
        plot.setToolTipGenerator(new StandardCategoryItemLabelGenerator("%s, %s, %s = %4$.0f"));
        StandardCategoryAxis3D rowAxis = (StandardCategoryAxis3D)plot.getRowAxis();
        rowAxis.setTickLabelGenerator(new StandardCategoryLabelGenerator("%s (%3$,.0f)"));
        StandardCategoryAxis3D columnAxis = (StandardCategoryAxis3D)plot.getColumnAxis();
        columnAxis.setTickLabelGenerator(new StandardCategoryLabelGenerator("%s (%3$,.0f)"));
        columnAxis.setTickLabelOrientation(LabelOrientation.PARALLEL);
        columnAxis.setMaxTickLabelLevels(2);
        StackedBarRenderer3D renderer = (StackedBarRenderer3D)plot.getRenderer();
        renderer.setColors(Colors.createIceCubeColors());
        return chart;
    }

    public static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D<String, String, String> dataset = new StandardCategoryDataset3D<String, String, String>();
        dataset.addValue(146, "Survivors", "Women/Children", "1st");
        dataset.addValue(104, "Survivors", "Women/Children", "2nd");
        dataset.addValue(103, "Survivors", "Women/Children", "3rd");
        dataset.addValue(20, "Survivors", "Women/Children", "Crew");
        dataset.addValue(57, "Survivors", "Men", "1st");
        dataset.addValue(14, "Survivors", "Men", "2nd");
        dataset.addValue(75, "Survivors", "Men", "3rd");
        dataset.addValue(192, "Survivors", "Men", "Crew");
        dataset.addValue(4, "Victims", "Women/Children", "1st");
        dataset.addValue(13, "Victims", "Women/Children", "2nd");
        dataset.addValue(141, "Victims", "Women/Children", "3rd");
        dataset.addValue(3, "Victims", "Women/Children", "Crew");
        dataset.addValue(118, "Victims", "Men", "1st");
        dataset.addValue(154, "Victims", "Men", "2nd");
        dataset.addValue(387, "Victims", "Men", "3rd");
        dataset.addValue(670, "Victims", "Men", "Crew");
        return dataset;
    }
}

