/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZItemKeys;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.interaction.StandardXYZDataItemSelection;
import com.orsoncharts.label.StandardXYZItemLabelGenerator;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo5
extends JFrame {
    public AxisRangeDemo5(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(AxisRangeDemo5.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel content = new CustomDemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        XYZDataset<String> dataset = AxisRangeDemo5.createDataset();
        Chart3D chart = Chart3DFactory.createScatterChart("AxisRangeDemo5", "Chart created with Orson Charts", dataset, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(10.0, 4.0, 10.0));
        ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
        renderer.setSize(0.1);
        StandardXYZItemLabelGenerator itemLabelGenerator = new StandardXYZItemLabelGenerator();
        StandardXYZDataItemSelection selection = new StandardXYZDataItemSelection();
        itemLabelGenerator.setItemSelection(selection);
        selection.addAll(XYZItemKeys.itemKeysForSeries(dataset, "S1"));
        renderer.setItemLabelGenerator(itemLabelGenerator);
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    private static XYZDataset<String> createDataset() {
        XYZSeries<String> s1 = AxisRangeDemo5.createRandomSeries("S1", 10);
        XYZSeries<String> s2 = AxisRangeDemo5.createRandomSeries("S2", 50);
        XYZSeries<String> s3 = AxisRangeDemo5.createRandomSeries("S3", 150);
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        dataset.add(s1);
        dataset.add(s2);
        dataset.add(s3);
        return dataset;
    }

    private static XYZSeries<String> createRandomSeries(String name, int count) {
        XYZSeries<String> s = new XYZSeries<String>(name);
        for (int i = 0; i < count; ++i) {
            s.add(Math.random() * 100.0, Math.random() * 10.0, Math.random() * 100.0);
        }
        return s;
    }

    public static void main(String[] args) {
        AxisRangeDemo5 app = new AxisRangeDemo5("OrsonCharts : AxisRangeDemo5.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider xslider1 = new JSlider(0, 50);
        private JSlider xslider2;
        private JSlider yslider1;
        private JSlider yslider2;
        private JSlider zslider1;
        private JSlider zslider2;

        public CustomDemoPanel(LayoutManager layout) {
            super(layout);
            this.xslider1.setValue(0);
            this.xslider2 = new JSlider(50, 100);
            this.xslider2.setValue(100);
            this.xslider1.addChangeListener(this);
            this.xslider2.addChangeListener(this);
            this.yslider1 = new JSlider(0, 50);
            this.yslider1.setValue(0);
            this.yslider2 = new JSlider(50, 100);
            this.yslider2.setValue(100);
            this.yslider1.addChangeListener(this);
            this.yslider2.addChangeListener(this);
            this.zslider1 = new JSlider(0, 50);
            this.zslider1.setValue(0);
            this.zslider2 = new JSlider(50, 100);
            this.zslider2.setValue(100);
            this.zslider1.addChangeListener(this);
            this.zslider2.addChangeListener(this);
            JPanel rangePanel = new JPanel(new GridLayout(3, 1));
            JPanel xPanel = new JPanel(new FlowLayout());
            xPanel.add(new JLabel("X axis: "));
            xPanel.add(new JLabel("Lower bound: "));
            xPanel.add(this.xslider1);
            xPanel.add(new JLabel("Upper bound: "));
            xPanel.add(this.xslider2);
            rangePanel.add(xPanel);
            JPanel yPanel = new JPanel(new FlowLayout());
            yPanel.add(new JLabel("Y axis: "));
            yPanel.add(new JLabel("Lower bound: "));
            yPanel.add(this.yslider1);
            yPanel.add(new JLabel("Upper bound: "));
            yPanel.add(this.yslider2);
            rangePanel.add(yPanel);
            JPanel zPanel = new JPanel(new FlowLayout());
            zPanel.add(new JLabel("Z axis: "));
            zPanel.add(new JLabel("Lower bound: "));
            zPanel.add(this.zslider1);
            zPanel.add(new JLabel("Upper bound: "));
            zPanel.add(this.zslider2);
            rangePanel.add(zPanel);
            this.add((Component)rangePanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double zmax;
            double ymax;
            double xmax;
            Chart3D chart = (Chart3D)this.getChartPanel().getDrawable();
            XYZPlot plot = (XYZPlot)chart.getPlot();
            ValueAxis3D xAxis = plot.getXAxis();
            double xmin = this.xslider1.getValue();
            if (xmin != (xmax = (double)this.xslider2.getValue())) {
                xAxis.setRange(xmin, xmax);
            }
            ValueAxis3D yAxis = plot.getYAxis();
            double ymin = (double)this.yslider1.getValue() / 10.0;
            if (ymin != (ymax = (double)this.yslider2.getValue() / 10.0)) {
                yAxis.setRange(ymin, ymax);
            }
            ValueAxis3D zAxis = plot.getZAxis();
            double zmin = this.zslider1.getValue();
            if (zmin != (zmax = (double)this.zslider2.getValue())) {
                zAxis.setRange(zmin, zmax);
            }
        }
    }
}

