/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemoComponent;
import com.orsoncharts.style.ChartStyle;
import com.orsoncharts.style.ChartStyles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class OrsonChartsDemo
extends JFrame
implements ActionListener {
    public static final Dimension DEFAULT_CONTENT_SIZE = new Dimension(760, 480);
    private OrsonChartsDemoComponent demoComponent;

    public OrsonChartsDemo(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.setJMenuBar(this.createMenuBar());
        this.add(this.createContent());
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu("File"));
        menuBar.add(this.createStyleMenu("Style"));
        return menuBar;
    }

    private JMenu createFileMenu(String title) {
        JMenu fileMenu = new JMenu(title);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setActionCommand("EXIT");
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        return fileMenu;
    }

    private JMenu createStyleMenu(String title) {
        JMenu styleMenu = new JMenu(title);
        JRadioButtonMenuItem noStyleMenuItem = new JRadioButtonMenuItem("No Style (style as coded)");
        noStyleMenuItem.setActionCommand("NO_STYLE");
        noStyleMenuItem.addActionListener(this);
        JRadioButtonMenuItem orson1StyleMenuItem = new JRadioButtonMenuItem("Orson 1 Style");
        orson1StyleMenuItem.setActionCommand("ORSON1_STYLE");
        orson1StyleMenuItem.addActionListener(this);
        JRadioButtonMenuItem orson2StyleMenuItem = new JRadioButtonMenuItem("Orson 2 Style");
        orson2StyleMenuItem.setActionCommand("ORSON2_STYLE");
        orson2StyleMenuItem.addActionListener(this);
        JRadioButtonMenuItem iceCubeStyleMenuItem = new JRadioButtonMenuItem("Ice Cube Style");
        iceCubeStyleMenuItem.setActionCommand("ICE_CUBE_STYLE");
        iceCubeStyleMenuItem.addActionListener(this);
        JRadioButtonMenuItem pastelStyleMenuItem = new JRadioButtonMenuItem("Pastel");
        pastelStyleMenuItem.setActionCommand("PASTEL_STYLE");
        pastelStyleMenuItem.addActionListener(this);
        JRadioButtonMenuItem logicalFontStyleMenuItem = new JRadioButtonMenuItem("Logical Font Style");
        logicalFontStyleMenuItem.setActionCommand("LOGICAL_FONT_STYLE");
        logicalFontStyleMenuItem.addActionListener(this);
        styleMenu.add(noStyleMenuItem);
        styleMenu.add(orson1StyleMenuItem);
        styleMenu.add(orson2StyleMenuItem);
        styleMenu.add(iceCubeStyleMenuItem);
        styleMenu.add(pastelStyleMenuItem);
        styleMenu.add(logicalFontStyleMenuItem);
        ButtonGroup group = new ButtonGroup();
        group.add(noStyleMenuItem);
        group.add(orson1StyleMenuItem);
        group.add(orson2StyleMenuItem);
        group.add(iceCubeStyleMenuItem);
        group.add(pastelStyleMenuItem);
        group.add(logicalFontStyleMenuItem);
        noStyleMenuItem.setSelected(true);
        return styleMenu;
    }

    private JComponent createContent() {
        JTabbedPane tabs = new JTabbedPane();
        this.demoComponent = new OrsonChartsDemoComponent();
        tabs.add("Demos", this.demoComponent);
        tabs.add("About", this.createAboutPanel());
        return tabs;
    }

    private JPanel createAboutPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setPreferredSize(new Dimension(800, 400));
        URL descriptionURL = OrsonChartsDemo.class.getResource("/com/orsoncharts/demo/about.html");
        try {
            textPane.setPage(descriptionURL);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JScrollPane scroller = new JScrollPane(textPane);
        result.add(scroller);
        return result;
    }

    private void applyStyleToChartsInPanels(List<Chart3DPanel> panels, ChartStyle style) {
        for (Chart3DPanel panel : panels) {
            Chart3D chart = (Chart3D)panel.getDrawable();
            ChartStyle s = style.clone();
            chart.setStyle(s);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component c;
        if ("EXIT".equals(e.getActionCommand())) {
            System.exit(0);
        }
        if ((c = this.demoComponent.getChartContainer().getComponent(0)) instanceof DemoPanel) {
            DemoPanel dp = (DemoPanel)c;
            List<Chart3DPanel> chartPanels = dp.getChartPanels();
            if ("NO_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(null);
            }
            if ("ORSON1_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(ChartStyles.createOrson1Style());
                this.applyStyleToChartsInPanels(chartPanels, ChartStyles.createOrson1Style());
            }
            if ("ORSON2_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(ChartStyles.createOrson2Style());
                this.applyStyleToChartsInPanels(chartPanels, ChartStyles.createOrson2Style());
            }
            if ("ICE_CUBE_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(ChartStyles.createIceCubeStyle());
                this.applyStyleToChartsInPanels(chartPanels, ChartStyles.createIceCubeStyle());
            }
            if ("PASTEL_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(ChartStyles.createPastelStyle());
                this.applyStyleToChartsInPanels(chartPanels, ChartStyles.createPastelStyle());
            }
            if ("LOGICAL_FONT_STYLE".equals(e.getActionCommand())) {
                this.demoComponent.setChartStyle(ChartStyles.createLogicalFontStyle());
                this.applyStyleToChartsInPanels(chartPanels, ChartStyles.createLogicalFontStyle());
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    try {
                        UIManager.setLookAndFeel(info.getClassName());
                    }
                    catch (Exception ex) {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                OrsonChartsDemo app = new OrsonChartsDemo("Orson Charts Demo 1.6");
                app.pack();
                app.setVisible(true);
            }
        });
    }
}

