/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.plot.XYZPlot;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class XYZLineChart3DDemo2
extends JFrame {
    public XYZLineChart3DDemo2(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(XYZLineChart3DDemo2.createDemoPanel());
    }

    private static XYZDataset createDataset() {
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        XYZSeries<String> series = new XYZSeries<String>("Series 1");
        series.add(5.0, 5.0, 5.0);
        series.add(15.0, 5.0, 5.0);
        series.add(15.0, 15.0, 5.0);
        series.add(5.0, 15.0, 5.0);
        series.add(5.0, 5.0, 5.0);
        series.add(5.0, 5.0, 15.0);
        series.add(15.0, 5.0, 15.0);
        series.add(15.0, 15.0, 15.0);
        series.add(5.0, 15.0, 15.0);
        series.add(5.0, 5.0, 15.0);
        series.add(5.0, 15.0, 15.0);
        series.add(5.0, 15.0, 5.0);
        series.add(15.0, 15.0, 5.0);
        series.add(15.0, 15.0, 15.0);
        series.add(15.0, 5.0, 15.0);
        series.add(15.0, 5.0, 5.0);
        dataset.add(series);
        return dataset;
    }

    private static Chart3D createChart(XYZDataset dataset) {
        Chart3D chart = Chart3DFactory.createXYZLineChart("XYZ Line Chart Demo", "Orson Charts", dataset, "X", "Y", "Z");
        chart.setChartBoxColor(new Color(255, 255, 255, 128));
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.getXAxis().setRange(0.0, 20.0);
        plot.getYAxis().setRange(0.0, 20.0);
        plot.getZAxis().setRange(0.0, 20.0);
        return chart;
    }

    public static JPanel createDemoPanel() {
        DemoPanel content = new DemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        XYZDataset dataset = XYZLineChart3DDemo2.createDataset();
        Chart3D chart = XYZLineChart3DDemo2.createChart(dataset);
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    public static void main(String[] args) {
        XYZLineChart3DDemo2 app = new XYZLineChart3DDemo2("OrsonCharts: XYZLineChart3DDemo2.java");
        app.pack();
        app.setVisible(true);
    }
}

