/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValue;
import com.orsoncharts.data.KeyedValue;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DefaultKeyedValues<K extends Comparable<K>, T>
implements KeyedValues<K, T>,
Serializable {
    private List<KeyedValue<K, T>> data;

    public DefaultKeyedValues() {
        this(new ArrayList());
    }

    public DefaultKeyedValues(List<K> keys) {
        ArgChecks.nullNotPermitted(keys, "keys");
        this.data = new ArrayList<KeyedValue<K, T>>();
        for (Comparable key : keys) {
            this.data.add(new DefaultKeyedValue<Comparable, Object>(key, null));
        }
    }

    public void clear() {
        this.data.clear();
    }

    public void put(K key, T value) {
        ArgChecks.nullNotPermitted(key, "key");
        int index = this.getIndex(key);
        if (index >= 0) {
            DefaultKeyedValue dkv = (DefaultKeyedValue)this.data.get(index);
            dkv.setValue(value);
        } else {
            this.data.add(new DefaultKeyedValue<K, T>(key, value));
        }
    }

    public void remove(K key) {
        ArgChecks.nullNotPermitted(key, "key");
        int index = this.getIndex(key);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        this.data.remove(index);
    }

    @Override
    public K getKey(int index) {
        KeyedValue<K, T> kv = this.data.get(index);
        return kv.getKey();
    }

    @Override
    public int getIndex(K key) {
        ArgChecks.nullNotPermitted(key, "key");
        for (int i = 0; i < this.data.size(); ++i) {
            KeyedValue<K, T> kv = this.data.get(i);
            if (!kv.getKey().equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<K> getKeys() {
        ArrayList<K> keys = new ArrayList<K>();
        for (KeyedValue<K, T> kv : this.data) {
            keys.add(kv.getKey());
        }
        return keys;
    }

    @Override
    public T getValue(K key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    @Override
    public T getValue(int item) {
        KeyedValue<K, T> kv = this.data.get(item);
        return kv.getValue();
    }

    @Override
    public double getDoubleValue(int item) {
        T n = this.getValue(item);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues)) {
            return false;
        }
        DefaultKeyedValues that = (DefaultKeyedValues)obj;
        return this.data.equals(that.data);
    }
}

