/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.Range;
import com.orsoncharts.data.function.Function3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;

public class XYZDatasetUtils {
    public static XYZDataset<String> sampleFunction(Function3D f, String key, Range xrange, double xcount, Range zrange, double zcount) {
        return XYZDatasetUtils.sampleFunction(f, key, xrange.getMin(), xrange.getMax(), xcount, zrange.getMin(), zrange.getMax(), zcount);
    }

    public static XYZDataset<String> sampleFunction(Function3D f, String key, double xmin, double xmax, double xcount, double zmin, double zmax, double zcount) {
        XYZSeries<String> s = new XYZSeries<String>(key);
        for (double x = xmin; x <= xmax; x += (xmax - xmin) / xcount) {
            for (double z = zmin; z <= zmax; z += (zmax - zmin) / zcount) {
                s.add(x, f.getValue(x, z), z);
            }
        }
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        dataset.add(s);
        return dataset;
    }
}

