/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fx;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.tk.Toolkit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import javafx.scene.canvas.GraphicsContext;

public class FXFontMetrics
extends FontMetrics {
    private Graphics2D g2;
    private GraphicsContext ctx;
    private TextLayout layout = Toolkit.getToolkit().getTextLayoutFactory().createLayout();

    public FXFontMetrics(Font font, Graphics2D g2, GraphicsContext ctx) {
        super(font);
        this.g2 = g2;
        this.ctx = ctx;
    }

    @Override
    public Rectangle2D getStringBounds(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
        char[] arr = new char[limit - beginIndex];
        ci.setIndex(beginIndex);
        for (int idx = 0; idx < arr.length; ++idx) {
            arr[idx] = ci.current();
            ci.next();
        }
        return this.getStringBounds(arr, beginIndex, limit, context);
    }

    @Override
    public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
        String str = new String(chars, beginIndex, limit - beginIndex);
        return this.getStringBounds(str, context);
    }

    @Override
    public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
        String substr = str.substring(beginIndex, limit);
        return super.getStringBounds(substr, context);
    }

    @Override
    public Rectangle2D getStringBounds(String str, Graphics context) {
        this.layout.setContent(str, this.ctx.getFont().impl_getNativeFont());
        this.layout.setBoundsType(8);
        BaseBounds bb = this.layout.getBounds();
        return new Rectangle2D.Double(bb.getMinX(), bb.getMinY(), bb.getWidth(), bb.getHeight());
    }

    @Override
    public int stringWidth(String str) {
        return (int)this.getStringBounds(str, this.g2).getWidth();
    }
}

