/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.axis.LabelOrientation;
import com.orsoncharts.axis.LogAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import com.orsoncharts.style.ChartStyler;
import java.awt.Color;

public class ScatterPlot3D2 {
    public static Chart3D createChart(XYZDataset dataset) {
        Chart3D chart = Chart3DFactory.createScatterChart("ScatterPlot3DDemo2", null, dataset, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
        plot.setDimensions(new Dimension3D(10.0, 6.0, 10.0));
        renderer.setSize(0.1);
        renderer.setColors(new Color(255, 128, 128), new Color(128, 255, 128));
        LogAxis3D yAxis = new LogAxis3D("Y (log scale)");
        yAxis.setTickLabelOrientation(LabelOrientation.PERPENDICULAR);
        yAxis.receive(new ChartStyler(chart.getStyle()));
        plot.setYAxis(yAxis);
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        return chart;
    }

    public static XYZDataset<String> createDataset() {
        XYZSeries<String> s1 = new XYZSeries<String>("S1");
        for (int i = 0; i < 1000; ++i) {
            s1.add(Math.random() * 100.0, Math.pow(10.0, Math.random() * 5.0), Math.random() * 100.0);
        }
        XYZSeries<String> s2 = new XYZSeries<String>("S2");
        for (int i = 0; i < 1000; ++i) {
            s2.add(Math.random() * 100.0, Math.random() * 100000.0, Math.random() * 100.0);
        }
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        dataset.add(s1);
        dataset.add(s2);
        return dataset;
    }
}

