/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.KeyedValues3DItemKeys;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.demo.CategoryMarker1;
import com.orsoncharts.demo.HighlightCategoryColorSource;
import com.orsoncharts.fx.Chart3DViewer;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.interaction.KeyedValues3DItemSelection;
import com.orsoncharts.interaction.StandardKeyedValues3DItemSelection;
import com.orsoncharts.interaction.fx.FXChart3DMouseEvent;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.style.ChartStyler;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class CategoryMarkerFXDemo1
extends Application {
    public static Node createDemoNode() {
        CategoryDataset3D dataset = CategoryMarker1.createDataset();
        Chart3D chart = CategoryMarker1.createChart(dataset);
        CustomDemoNode node = new CustomDemoNode(chart);
        return node;
    }

    public void start(Stage stage) throws Exception {
        StackPane sp = new StackPane();
        sp.getChildren().add((Object)CategoryMarkerFXDemo1.createDemoNode());
        Scene scene = new Scene((Parent)sp, 768.0, 512.0);
        stage.setScene(scene);
        stage.setTitle("Orson Charts: CategoryMarkerFXDemo1.java");
        stage.show();
    }

    public static void main(String[] args) {
        CategoryMarkerFXDemo1.launch((String[])args);
    }

    static class CustomDemoNode
    extends BorderPane {
        private Chart3DViewer chartViewer;
        private String selectedRowKey;
        private String selectedColumnKey;
        private CheckBox itemLabelCheckBox;

        public CustomDemoNode(Chart3D chart) {
            this.chartViewer = new Chart3DViewer(chart);
            this.chartViewer.addEventHandler(FXChart3DMouseEvent.MOUSE_CLICKED, event -> this.chartMouseClicked((FXChart3DMouseEvent)event));
            this.selectedRowKey = "Apple";
            this.selectedColumnKey = "Q4/12";
            this.itemLabelCheckBox = new CheckBox("Show item labels?");
            this.itemLabelCheckBox.setOnAction(e -> {
                this.updateItemSelection(this.selectedRowKey, this.selectedColumnKey);
                chart.setNotify(true);
            });
            this.setCenter((Node)this.chartViewer);
            HBox container = new HBox();
            container.setAlignment(Pos.CENTER);
            container.setPadding(new Insets(4.0, 4.0, 4.0, 4.0));
            container.getChildren().add((Object)this.itemLabelCheckBox);
            this.setBottom((Node)container);
        }

        private void updateColorSource(String selectedRow, String selectedColumn) {
            HighlightCategoryColorSource colorSource = (HighlightCategoryColorSource)this.getRenderer().getColorSource();
            int rowIndex = this.getPlot().getDataset().getRowIndex(selectedRow);
            int columnIndex = this.getPlot().getDataset().getColumnIndex(selectedColumn);
            colorSource.setHighlightRowIndex(rowIndex);
            colorSource.setHighlightColumnIndex(columnIndex);
        }

        private void updateItemSelection(String selectedRow, String selectedColumn) {
            StandardKeyedValues3DItemSelection itemSelection = (StandardKeyedValues3DItemSelection)this.getItemSelection();
            itemSelection.clear();
            if (this.itemLabelCheckBox.isSelected()) {
                itemSelection.addAll(KeyedValues3DItemKeys.itemKeysForColumn(this.getPlot().getDataset(), selectedColumn));
                itemSelection.addAll(KeyedValues3DItemKeys.itemKeysForRow(this.getPlot().getDataset(), selectedRow));
            }
        }

        private CategoryPlot3D getPlot() {
            Chart3D chart = this.chartViewer.getChart();
            return (CategoryPlot3D)chart.getPlot();
        }

        private BarRenderer3D getRenderer() {
            return (BarRenderer3D)this.getPlot().getRenderer();
        }

        private KeyedValues3DItemSelection getItemSelection() {
            StandardCategoryItemLabelGenerator generator = (StandardCategoryItemLabelGenerator)this.getRenderer().getItemLabelGenerator();
            return generator.getItemSelection();
        }

        private void handleSelectItem(Comparable rowKey, Comparable columnKey) {
            StandardCategoryAxis3D columnAxis;
            CategoryMarker columnMarker;
            Chart3D chart = this.chartViewer.getChart();
            chart.setNotify(false);
            CategoryPlot3D plot = this.getPlot();
            StandardCategoryAxis3D rowAxis = (StandardCategoryAxis3D)plot.getRowAxis();
            CategoryMarker rowMarker = rowAxis.getMarker("RM1");
            if (rowMarker == null) {
                rowMarker = new CategoryMarker((Comparable<?>)((Object)""));
                rowMarker.receive(new ChartStyler(chart.getStyle()));
            }
            if ((columnMarker = (columnAxis = (StandardCategoryAxis3D)plot.getColumnAxis()).getMarker("CM1")) == null) {
                columnMarker = new CategoryMarker((Comparable<?>)((Object)""));
                columnMarker.receive(new ChartStyler(chart.getStyle()));
            }
            this.selectedRowKey = rowKey.toString();
            this.selectedColumnKey = columnKey.toString();
            rowMarker.setCategory((Comparable<?>)((Object)this.selectedRowKey));
            columnMarker.setCategory((Comparable<?>)((Object)this.selectedColumnKey));
            this.updateColorSource(this.selectedRowKey, this.selectedColumnKey);
            this.updateItemSelection(this.selectedRowKey, this.selectedColumnKey);
            chart.setNotify(true);
        }

        private void handleSelectRow(Comparable rowKey) {
            this.handleSelectItem(rowKey, (Comparable)((Object)this.selectedColumnKey));
        }

        private void handleSelectColumn(Comparable columnKey) {
            this.handleSelectItem((Comparable)((Object)this.selectedRowKey), columnKey);
        }

        public void chartMouseClicked(FXChart3DMouseEvent event) {
            RenderedElement element = event.getElement();
            if (element == null) {
                return;
            }
            KeyedValues3DItemKey key = (KeyedValues3DItemKey)element.getProperty("key");
            if (key != null) {
                this.handleSelectItem((Comparable)key.getRowKey(), (Comparable)key.getColumnKey());
            } else if (InteractiveElementType.CATEGORY_AXIS_TICK_LABEL.equals(element.getType())) {
                String label = (String)element.getProperty("label");
                String axisStr = (String)element.getProperty("axis");
                if (axisStr.equals("row")) {
                    this.handleSelectRow((Comparable)((Object)label));
                } else {
                    this.handleSelectColumn((Comparable)((Object)label));
                }
            } else if (InteractiveElementType.LEGEND_ITEM.equals(element.getType())) {
                Comparable seriesKey = (Comparable)element.getProperty("series_key");
                this.handleSelectRow(seriesKey);
            }
        }
    }
}

