/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.axis.LabelOrientation;
import com.orsoncharts.axis.LogAxis3D;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.demo.ScatterPlot3D2;
import com.orsoncharts.fx.Chart3DViewer;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.style.ChartStyler;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class ScatterPlot3DFXDemo2
extends Application {
    public static Node createDemoNode() {
        XYZDataset<String> dataset = ScatterPlot3D2.createDataset();
        Chart3D chart = ScatterPlot3D2.createChart(dataset);
        Chart3DViewer viewer = new Chart3DViewer(chart);
        BorderPane node = new BorderPane();
        node.setCenter((Node)viewer);
        HBox container = new HBox();
        CheckBox checkBox = new CheckBox("Logarithmic Axis?");
        checkBox.setSelected(true);
        checkBox.setOnAction(e -> {
            XYZPlot plot = (XYZPlot)chart.getPlot();
            if (checkBox.isSelected()) {
                LogAxis3D logAxis = new LogAxis3D("Y (log scale)");
                logAxis.setTickLabelOrientation(LabelOrientation.PERPENDICULAR);
                logAxis.receive(new ChartStyler(chart.getStyle()));
                plot.setYAxis(logAxis);
            } else {
                NumberAxis3D yAxis = new NumberAxis3D("Y");
                yAxis.setTickLabelOrientation(LabelOrientation.PERPENDICULAR);
                yAxis.receive(new ChartStyler(chart.getStyle()));
                plot.setYAxis(yAxis);
            }
        });
        container.setAlignment(Pos.CENTER);
        container.setPadding(new Insets(4.0, 4.0, 4.0, 4.0));
        container.getChildren().add((Object)checkBox);
        node.setBottom((Node)container);
        return node;
    }

    public void start(Stage stage) throws Exception {
        StackPane sp = new StackPane();
        sp.getChildren().add((Object)ScatterPlot3DFXDemo2.createDemoNode());
        Scene scene = new Scene((Parent)sp, 768.0, 512.0);
        stage.setScene(scene);
        stage.setTitle("Orson Charts: ScatterPlotFXDemo2.java");
        stage.show();
    }

    public static void main(String[] args) {
        ScatterPlot3DFXDemo2.launch((String[])args);
    }
}

