/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.demo.XYZLineChart3D2;
import com.orsoncharts.fx.Chart3DViewer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDate;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class XYZLineChart3DFXDemo2
extends Application {
    public static Node createDemoNode() {
        XYZDataset<String> dataset = XYZLineChart3DFXDemo2.createDataset();
        Chart3D chart = XYZLineChart3D2.createChart(dataset);
        Chart3DViewer viewer = new Chart3DViewer(chart);
        return viewer;
    }

    private static XYZDataset<String> createDataset() {
        BufferedReader in = new BufferedReader(new InputStreamReader(XYZLineChart3D2.class.getResourceAsStream("fxrates.csv")));
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        XYZSeries<String> aud = new XYZSeries<String>("AUD");
        XYZSeries<String> brl = new XYZSeries<String>("BRL");
        XYZSeries<String> chf = new XYZSeries<String>("CHF");
        XYZSeries<String> cny = new XYZSeries<String>("CNY");
        XYZSeries<String> eur = new XYZSeries<String>("EUR");
        XYZSeries<String> gbp = new XYZSeries<String>("GBP");
        XYZSeries<String> jpy = new XYZSeries<String>("JPY");
        try {
            String line = in.readLine();
            while ((line = in.readLine()) != null) {
                String[] items = line.split(",");
                LocalDate d = LocalDate.parse(items[0]);
                aud.add(d.toEpochDay(), Double.valueOf(items[2]), 1.0);
                brl.add(d.toEpochDay(), Double.valueOf(items[4]), 2.0);
                chf.add(d.toEpochDay(), Double.valueOf(items[6]), 3.0);
                cny.add(d.toEpochDay(), Double.valueOf(items[8]), 4.0);
                eur.add(d.toEpochDay(), Double.valueOf(items[10]), 5.0);
                gbp.add(d.toEpochDay(), Double.valueOf(items[12]), 6.0);
                jpy.add(d.toEpochDay(), Double.valueOf(items[14]), 7.0);
            }
            dataset.add(aud);
            dataset.add(brl);
            dataset.add(chf);
            dataset.add(cny);
            dataset.add(eur);
            dataset.add(gbp);
            dataset.add(jpy);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return dataset;
    }

    public void start(Stage stage) throws Exception {
        StackPane sp = new StackPane();
        sp.getChildren().add((Object)XYZLineChart3DFXDemo2.createDemoNode());
        Scene scene = new Scene((Parent)sp, 768.0, 512.0);
        stage.setScene(scene);
        stage.setTitle("Orson Charts: XYZLineChart3DFXDemo2.java");
        stage.show();
    }

    public static void main(String[] args) {
        XYZLineChart3DFXDemo2.launch((String[])args);
    }
}

