/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Range;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.function.Function3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.RainbowScale;
import com.orsoncharts.renderer.xyz.SurfaceRenderer;
import com.orsoncharts.util.Orientation;

public class SurfaceRenderer2 {
    public static Chart3D createChart() {
        Function3D function = new Function3D(){

            @Override
            public double getValue(double x, double z) {
                return Math.sin(x * x + z * z);
            }
        };
        Chart3D chart = Chart3DFactory.createSurfaceChart("SurfaceRendererDemo2", "y = sin(x^2 + z^2)", function, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(10.0, 5.0, 10.0));
        ValueAxis3D xAxis = plot.getXAxis();
        xAxis.setRange(-2.0, 2.0);
        ValueAxis3D zAxis = plot.getZAxis();
        zAxis.setRange(-2.0, 2.0);
        SurfaceRenderer renderer = (SurfaceRenderer)plot.getRenderer();
        renderer.setColorScale(new RainbowScale(new Range(-1.0, 1.0)));
        renderer.setDrawFaceOutlines(false);
        chart.setLegendPosition(LegendAnchor.BOTTOM_RIGHT, Orientation.VERTICAL);
        return chart;
    }
}

